% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats.R
\name{LocalMoransIStats}
\alias{LocalMoransIStats}
\title{Local Moran's I statistics}
\usage{
LocalMoransIStats(X, W, scale = FALSE)
}
\arguments{
\item{X}{A matrix with observations as rows and features as columns.}

\item{W}{A weight matrix across all observations, i.e inverse of a pairwise distance matrix.}

\item{scale}{Whether to scale the data. Default is \code{FALSE}.}
}
\value{
A list containing the following:
\itemize{
\item E.I, the expectation of local Moran's I under the null hypothesis.
\item SD.I, the standard deviation of local Moran's I under the null hypothesis.
}
}
\description{
Calculate theoretical expectation and standard deviation of local Moran's I under the null hypothesis.
}
\examples{
{
data.use <- quakes[1:100,]
W <- 1/as.matrix(dist(data.use[,1:2]))
diag(W) <- 0
res <- LocalMoransIStats(data.use[,3:4], W)
}
}
\references{
Anselin, L. Local indicators of spatial association-LISA. Geogr. Anal. 27, 93–115 (1995)

Sokal, R. R., Oden, N. L. & Thomson, B. A. Local spatial autocorrelation in a biological model. Geogr. Anal. 30, 331–354 (1998)
}
\concept{stats}
