% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/player.R
\name{set_my_repeat_mode}
\alias{set_my_repeat_mode}
\title{Set User Playback Mode}
\usage{
set_my_repeat_mode(
  state,
  device_id = NULL,
  authorization = get_spotify_authorization_code()
)
}
\arguments{
\item{state}{Required. \cr
\code{"track"}, \code{"context"}, or \code{"off"}
\code{"track"} will repeat the current track. \cr
\code{"context"} will repeat the current context. \cr
\code{"off"} will turn repeat off}

\item{device_id}{Optional. The id of the device this command is targeting. If not supplied, the user’s currently active device is the target.}

\item{authorization}{Required. A valid access token from the Spotify Accounts service. See the \href{https://developer.spotify.com/documentation/general/guides/authorization-guide/}{Web API authorization Guide} for more details. Defaults to \code{spotifyr::get_spotify_access_token()}. The access token must have been issued on behalf of the current user. \cr
The access token must have the \code{user-modify-playback-state} scope authorized
in order to control playback.}
}
\value{
The response from the Spotify Web API on the \code{PUT} request, with a meaningful
error message if the operation was not successful.
}
\description{
Set the repeat mode for the user’s playback.
Options are repeat-track, repeat-context, and off.
}
\seealso{
Other player functions: 
\code{\link{get_my_current_playback}()},
\code{\link{get_my_currently_playing}()},
\code{\link{get_my_devices}()},
\code{\link{get_my_recently_played}()},
\code{\link{pause_my_playback}()},
\code{\link{seek_to_position}()},
\code{\link{skip_my_playback_previous}()},
\code{\link{skip_my_playback}()},
\code{\link{start_my_playback}()},
\code{\link{toggle_my_shuffle}()},
\code{\link{transfer_my_playback}()}
}
\concept{player functions}
