% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spork-to-plotmath.R
\name{spork_to_plotmath}
\alias{spork_to_plotmath}
\title{Convert One Spork to Plotmath}
\usage{
spork_to_plotmath(
  x,
  unrecognized = getOption("plotmath_unrecognized", "plotmathToken"),
  ...
)
}
\arguments{
\item{x}{character}

\item{unrecognized}{function to process unrecognized tokens: default \code{\link{plotmathToken}}}

\item{...}{ignored}
}
\value{
character
}
\description{
Converts one spork to plotmath.
See description for \code{\link{as_spork}}.
By default, unrecognized tokens are returned
unmodified if they are parseable.
Otherwise, backslashes and single quotes are escaped,
and the result is wrapped in single quotes.
See \code{\link{plotmathToken}}.
}
\examples{
library(magrittr)
'V_c./F' \%>\% spork_to_plotmath
'AUC_ss' \%>\% spork_to_plotmath
'C_max_ss' \%>\% spork_to_plotmath
'var^eta_j' \%>\% spork_to_plotmath
}
\seealso{
Other plotmath: 
\code{\link{as_plotmath.spork}()},
\code{\link{as_plotmath}()},
\code{\link{goodToken}()},
\code{\link{plotmathToken}()}
}
\concept{plotmath}
\keyword{internal}
