% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/map_gist.R
\name{map_gist}
\alias{map_gist}
\title{Make an interactive map to view in the browser as a Github gist}
\usage{
map_gist(data, description = "", public = TRUE, browse = TRUE, ...)
}
\arguments{
\item{data}{A data.frame, with any number of columns, but with at least the
following: name (the taxonomic name), latitude (in dec. deg.), longitude
(in dec. deg.)}

\item{description}{Description for the Github gist, or leave to default (=no description)}

\item{public}{(logical) Whether gist is public (default: TRUE)}

\item{browse}{If TRUE (default) the map opens in your default browser.}

\item{...}{Further arguments passed on to \code{\link{style_geojson}}}
}
\description{
Make an interactive map to view in the browser as a Github gist
}
\details{
See \code{\link[gistr]{gist_auth}} for help on authentication
}
\examples{
\dontrun{
library("spocc")
spp <- c('Danaus plexippus','Accipiter striatus','Pinus contorta')
dat <- occ(spp, from=c('gbif','ecoengine'), limit=30, gbifopts=list(hasCoordinate=TRUE))
dat <- fixnames(dat, "query")

# Define colors
map_gist(data=dat, color=c('#976AAE','#6B944D','#BD5945'))
map_gist(data=dat$gbif, color=c('#976AAE','#6B944D','#BD5945'))
map_gist(data=dat$ecoengine, color=c('#976AAE','#6B944D','#BD5945'))

# Define colors and marker size
map_gist(data=dat, color=c('#976AAE','#6B944D','#BD5945'), size=c('small','medium','large'))

# Define symbols
map_gist(data=dat, symbol=c('park','zoo','garden'))
}
}

