test_that("get_randcov_names works", {
  expect_equal(get_randcov_names(~group), "1 | group")
  expect_equal(get_randcov_names(~ 1 | group), "1 | group")
  expect_equal(get_randcov_names(~ group + subgroup), c("1 | group", "1 | subgroup"))
  expect_equal(get_randcov_names(~ group:subgroup), "1 | group:subgroup")
  expect_equal(get_randcov_names(~ group / subgroup), c("1 | group", "1 | group:subgroup"))
  expect_equal(get_randcov_names(~ 1 | group / subgroup), c("1 | group", "1 | group:subgroup"))
  expect_equal(get_randcov_names(~ x | group), c("1 | group", "x | group"))
  expect_equal(get_randcov_names(~ x - 1 | group), c("x | group"))
  expect_equal(get_randcov_names(~ group + (x | group)), c("1 | group", "1 | group", "x | group"))
  expect_equal(get_randcov_names(~ group * x | group), c("1 | group", "group | group", "x | group", "group:x | group"))
  expect_equal(get_randcov_names(~ (x | group) + (x | subgroup)), c("1 | group", "x | group", "1 | subgroup", "x | subgroup"))
  # expect_equal(get_randcov_names(~ group + x | group), c("group + x | group")) # force error here (not intended as () MUST be there)
})
