% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coefficients.R
\name{flanagan_rulon}
\alias{flanagan_rulon}
\title{Calculate Flanagon-Rulon coefficient}
\usage{
flanagan_rulon(x, y)
}
\arguments{
\item{x}{(vector) a numeric vector}

\item{y}{(vector) a numeric vector with compatible dimensions to x}
}
\value{
(numeric) Flanagon-Rulon coefficient
}
\description{
Flanagon-Rulon reliability coefficient. Formula obtained from
Warrens (2015) <\doi{10.1007/s11634-015-0198-6}>
}
\examples{
# Generate two variables with different means, variances and a correlation of about 0.5
library(MASS)
vars = mvrnorm(30, mu = c(0, 2), Sigma = matrix(c(5, 2, 2, 3), ncol = 2), empirical = TRUE)
# Calculate coefficient
flanagan_rulon(vars[,1], vars[,2])
}
\seealso{
Other splithalfr coefficients: 
\code{\link{angoff_feldt}()},
\code{\link{assmd}()},
\code{\link{sdregi}()},
\code{\link{short_icc}()},
\code{\link{spearman_brown}()}
}
\concept{splithalfr coefficients}
