% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mmqn_step.r
\name{ddg}
\alias{ddg}
\title{Compute the approximate Hessian of the majorization.}
\usage{
ddg(x, v, w, hgrad)
}
\arguments{
\item{x}{non-anchor point}

\item{v}{weights for first set of constraints}

\item{w}{weights for second set of constraints}

\item{hgrad}{Handle for output mapping Jacobian}
}
\description{
\code{ddg} computes the Hessian of the majorization of the proximity function.
}
\examples{
set.seed(12345)
n <- 10
p <- 2
x <- matrix(rnorm(p),p,1)
v <- 1
w <- 1
A <- matrix(rnorm(n*p),n,p)
hgrad <- function(x) {return(t(A))}
sol <- ddg(x,v,w,hgrad)
}
