% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2_ggproto_visualize.r
\name{animate_gganimate}
\alias{animate_gganimate}
\title{Animate a ggtour as a .gif via \code{{gganimate}}}
\usage{
animate_gganimate(
  ggtour,
  fps = 8,
  rewind = FALSE,
  start_pause = 1,
  end_pause = 1,
  ...
)
}
\arguments{
\item{ggtour}{A grammar of graphics tour with appended protos added.
A return from \verb{ggtour() + proto_*()}.}

\item{fps}{Scalar number of Frames Per Second, the speed the animation should
play at.}

\item{rewind}{Whether or not the animation should play backwards,
in reverse order once reaching the end. Defaults to FALSE.}

\item{start_pause}{The duration in seconds to wait before starting the
animation. Defaults to 1 second.}

\item{end_pause}{The duration in seconds to wait after ending the animation,
before it restarts from the first frame. Defaults to 1 second.}

\item{...}{Other arguments passed to
\code{\link[gganimate:animate]{gganimate::animate}}.}
}
\description{
Animates the ggplot return of \code{ggtour()} and added \verb{proto_*()} functions as a
.gif without interaction, through use of \code{{gganimate}}.
}
\examples{
dat <- scale_sd(tourr::flea[, 1:6])
clas <- tourr::flea$species
bas <- basis_pca(dat)
mv <- manip_var_of(bas)
mt_path <- manual_tour(bas, manip_var = mv)

ggt <- ggtour(mt_path, dat, angle = .1) +
  proto_basis() +
  proto_origin() +
  proto_point(aes_args = list(color = clas, shape = clas),
              identity_args = list(size = 1.5, alpha = .7))

\dontrun{
animate_gganimate(ggt)

## Example saving gganime to a .gif, may require additional setup.
if(F){
  anim <- animate_gganimate(ggt, fps = 10, rewind = TRUE,
                            start_pause = 1, end_pause = 2)
  gganimate::anim_save("my_tour.gif",
                       animation = anim,
                       path = "./figures")}}
}
\seealso{
\code{\link[gganimate:animate]{gganimate::animate}}

Other ggtour animator: 
\code{\link{animate_plotly}()}
}
\concept{ggtour animator}
