#' Wisconsin Breast Cancer Database
#'
#' Formatted subset of `mlbench::BreastCancer`. See `mlbench` for original data 
#' more context.
#' 
#' The objective is to identify each of a number of benign or malignant classes.
#' Samples arrive periodically as Dr. Wolberg reports his clinical cases. The 
#' database therefore reflects this chronological grouping of the data. This 
#' grouping information appears immediately below, having been removed from 
#' the data itself. Each variable except for the first was converted into 11 
#' primitive numerical attributes with values ranging from 0 through 10. There 
#' are 16 missing attribute values.
#'
#' Data frame with 675 observations on 10 variables: a factor Id, 
#' 9 numeric variables, and target class:
#' \itemize{
#'   \item Id, Sample code number
#'   \item Cl.thickness, Clump thickness
#'   \item Cell.size, Uniformity of cell size
#'   \item Cell.shape, Uniformity of cell shape
#'   \item Marg.adhesion, Marginal adhesion
#'   \item Epith.c.size, Single Epthelial cell size
#'   \item Bare.nuclei, Bare nuclei
#'   \item Bl.cromatin, Bland chromatin
#'   \item Normal.nucleoli, Normal Nucleoli
#'   \item Class, Class
#' }
#' @details 
#' Reproducing this dataset:
#' ```
#' requireNamespace("mlbench")
#' data(BreastCancer)
#' 
#' d <- BreastCancer
#' d <- d[!duplicated(d), ]
#' d <- d[complete.cases(d), ]
#' mat <- as.matrix(d[ , 2:9])
#' mat <- apply(mat, 2, as.numeric)
#' breastcancer <- data.frame(Id = d$Id, mat, Class = d$Class)
#' ```
#' @name breastcancer
#' @docType data
#' @format Data frame with 675 observations on 10 variables: a factor 
#' Id, 9 numeric variables, and target class.
#' @keywords datasets
#' @examples
#' str(breastcancer)
#' \dontrun{
#' play_manual_tour(data = breastcancer[, 2:9], manip_var = 3, rescale_data = TRUE)
#' }
"breastcancer"

#' Sample dataset of daily weather observations from Canberra airport in Australia.
#' 
#' A subset from `rattle.data::weather`, instructions to reproduce below.
#' 
#' One year of daily weather observations collected from the Canberra airport 
#' in Australia was obtained from the Australian Commonwealth Bureau of 
#' Meteorology and processed to create this sample dataset for illustrating 
#' data mining using R and Rattle.
#' 
#' The data has been processed to provide a target variable RainTomorrow 
#' (whether there is rain on the following day - No/Yes) and a risk variable 
#' `RISK_MM`` (how much rain recorded in millimeters). Various transformations 
#' were performed on the source data. The dataset is quite small and is useful 
#' only for repeatable demonstration of various data science operations.
#' 
#' The source dataset is Copyright by the Australian Commonwealth Bureau of 
#' Meteorology and is provided as part of the rattle package with permission.
#'
#' Data frame of 366 observations of 20 variables, one year of 
#' daily observations of weather variables at Canberra airport in Australia 
#' starting November 2007:
#' \itemize{
#'   \item Date, The date of observation (a Date object).
#'   \item MinTemp, The minimum temperature in degrees Celsius.
#'   \item MaxTemp, The maximum temperature in degrees Celsius.
#'   \item Rainfall, The amount of rainfall recorded for the day in mm.
#'   \item Evaporation, The so-called Class A pan evaporation (mm) in the 24 hours to 9am.
#'   \item Sunshine, The number of hours of bright sunshine in the day.
#'   \item WindGustSpeed, The speed (km/h) of the strongest wind gust in the 24 hours to midnight.
#'   \item WindSpeed9am, Wind speed (km/hr) averaged over 10 minutes prior to 9am.
#'   \item WindSpeed3pm, Wind speed (km/hr) averaged over 10 minutes prior to 3pm.
#'   \item Humid9am, Relative humidity (percent) at 9am.
#'   \item Humid3pm, Relative humidity (percent) at 3pm.
#'   \item Pressure9am, Atmospheric pressure (hpa) reduced to mean sea level at 9am.
#'   \item Pressure3pm, Atmospheric pressure (hpa) reduced to mean sea level at 3pm.
#'   \item Cloud9am, Fraction of sky obscured by cloud at 9am. This is measured in "oktas", which are a unit of eighths. It records how many eighths of the sky are obscured by cloud. A 0 measure indicates completely clear sky whilst an 8 indicates that it is completely overcast.
#'   \item Cloud3pm, Fraction of sky obscured by cloud (in "oktas": eighths) at 3pm. See Cloud9am for a description of the values.
#'   \item Temp9am, Temperature (degrees C) at 9am.
#'   \item Temp3pm, Temperature (degrees C) at 3pm.
#'   \item RainToday, Integer: 1 if precipitation (mm) in the 24 hours to 9am exceeds 1mm, otherwise 0.
#'   \item RISK_MM, The amount of rain. A kind of measure of the "risk".
#'   \item RainTomorrow, The target variable. Did it rain tomorrow?
#' }
#' @details 
#' Reproducing this dataset:
#' ```
#' requireNamespace("rattle.data")
#' weather <- weather[, c(1,3:7,9,12:24)]
#' ```
#' @name weather
#' @docType data
#' @format Data frame of 366 observations of 20 variables, one year of 
#' daily observations of weather variables at Canberra airport in Australia 
#' starting November 2007.
#' @source The daily observations are available from http://www.bom.gov.au/climate/data. 
#' Copyright Commonwealth of Australia 2010,
#' Bureau of Meteorology. 
#'
#' Definitions adapted from http://www.bom.gov.au/climate/dwo/IDCJDW0000.shtml
#' @references Data source: http://www.bom.gov.au/climate/dwo/ and http://www.bom.gov.au/climate/data.
#' @keywords datasets
#' @examples
#' str(weather)
#' \dontrun{
#' play_manual_tour(data = weather[, 2:17], manip_var = 5, rescale_data = TRUE)
#' }
"weather"

#' The wine dataset from the UCI Machine Learning Repository.
#'
#' The wine dataset contains the results of a chemical analysis of wines grown 
#' in a specific area of Italy. Three types of wine are represented in the 178 
#' samples, with the results of 13 chemical analyses recorded for each sample. 
#' The Type variable has been transformed into a categorical variable.
#' 
#' The data contains no missing values and consist of only numeric data, with a 
#' three class target variable (Type) for classification.
#'
#' Data frame of 178 observations of 13 variables, target 
#' class `Type` and 12 numeric variables:
#' \itemize{
#'   \item Type, The type of wine, into one of three classes, 1 (59 obs), 
#'   2(71 obs), and 3 (48 obs).
#'   \item Alcohol, Alcohol
#'   \item Malic, Malic acid
#'   \item Ash, Ash
#'   \item Alcalinity, Alcalinity of ash
#'   \item Magnesium, Magnesium
#'   \item Phenols, Total phenols
#'   \item Flavanoids, Flavanoids
#'   \item Nonflavanoids, Nonflavanoid phenols
#'   \item Proanthocyanins, Proanthocyanins
#'   \item Color, Color intensity
#'   \item Hue, Hue
#'   \item Dilution, D280/OD315 of diluted wines
#'   \item Proline, Proline
#' }
#' @details 
#' Reproducing this dataset:
#' ```
#' requireNamespace("rattle.data")
#' wine
#' ```
#' @name wine
#' @docType data
#' @format data frame of 178 observations of 13 variables, target 
#' class `Type` and 12 numeric variables.
#' @examples
#' str(wine)
#' \dontrun{
#' play_manual_tour(data = wine[, 2:14], manip_var = 1, rescale_data = TRUE)
#' }
"wine"