% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sperrorest_resampling.R
\name{represampling.tile.bootstrap}
\alias{represampling.tile.bootstrap}
\title{Spatial block bootstrap using rectangular blocks}
\usage{
represampling.tile.bootstrap(data, coords = c("x", "y"), repetition = 1,
  nboot = -1, seed1 = NULL, oob = FALSE, ...)
}
\arguments{
\item{data}{\code{data.frame} containing at least the columns specified
by \code{coords}}

\item{coords}{vector of length 2 defining the variables in \code{data} that
contain the x and y coordinates of sample locations.}

\item{repetition}{numeric vector: cross-validation repetitions
to be generated. Note that this is not the number of repetitions,
but the indices of these repetitions. E.g., use \code{repetition = c(1:100)}
to obtain (the 'first') 100 repetitions, and \code{repetition = c(101:200)}
to obtain a different set of 100 repetitions.}

\item{nboot}{see \code{\link[=represampling.factor.bootstrap]{represampling.factor.bootstrap()}}}

\item{seed1}{\code{seed1+i} is the random seed that will be used by
\code{\link[=set.seed]{set.seed()}} in repetition \code{i} (\code{i} in \code{repetition})
to initialize the random number generator before sampling from the data set.}

\item{oob}{see \code{\link[=represampling.factor.bootstrap]{represampling.factor.bootstrap()}}}

\item{...}{additional arguments to be passed to \code{\link[=partition.tiles]{partition.tiles()}}}
}
\description{
\code{represampling.tile.bootstrap} performs a non-overlapping spatial
block bootstrap by resampling at the level of rectangular partitions or
'tiles' generated by \code{\link[=partition.tiles]{partition.tiles()}}.
}
