% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spell-check.R
\name{spell_check_package}
\alias{spell_check_package}
\alias{spelling}
\alias{spell_check_setup}
\alias{spell_check_test}
\title{Package Spell Checking}
\usage{
spell_check_package(pkg = ".", vignettes = TRUE, use_wordlist = TRUE)

spell_check_setup(pkg = ".", vignettes = TRUE, lang = "en-US",
  error = FALSE)
}
\arguments{
\item{pkg}{path to package root directory containing the \code{DESCRIPTION} file}

\item{vignettes}{check all \code{rmd} and \code{rnw} files in the pkg root directory (e.g.
\code{readme.md}) and package \code{vignettes} folder.}

\item{use_wordlist}{ignore words in the package \link[=get_wordlist]{WORDLIST} file}

\item{lang}{set \code{Language} field in \code{DESCRIPTION} e.g. \code{"en-US"} or \code{"en-GB"}.
For supporting other languages, see the \href{https://bit.ly/2EquLKy}{hunspell vignette}.}

\item{error}{should \code{CMD check} fail if spelling errors are found?
Default only prints results.}
}
\description{
Automatically spell-check package description, documentation, and vignettes.
}
\details{
Parses and checks R manual pages, rmd/rnw vignettes, and text fields in the
package \code{DESCRIPTION} file.

The preferred spelling language (typically \code{en-GB} or \code{en-US}) should be specified
in the \code{Language} field from your package \code{DESCRIPTION}. To whitelist custom words
use the package \link[=get_wordlist]{WORDLIST} file which will be added to the dictionary
when spell checking. See \link{update_wordlist} to automatically populate and update this
file.

The \link{spell_check_setup} function adds a unit test to your package which automatically
runs a spell check on documentation and vignettes during \code{R CMD check} if the environment
variable \code{NOT_CRAN} is set to \code{TRUE}. By default this unit test never fails; it merely
prints potential spelling errors to the console.

Hunspell includes dictionaries for \code{en_US} and \code{en_GB} by default. Other languages
require installation of a custom dictionary, see \link[hunspell:hunspell]{hunspell} for details.
}
\seealso{
Other spelling: \code{\link{spell_check_files}},
  \code{\link{wordlist}}
}
\concept{spelling}
