/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.util;

import bibliothek.gui.DockController;
import bibliothek.gui.dock.themes.ThemeManager;
import bibliothek.gui.dock.util.BackgroundComponent;
import bibliothek.gui.dock.util.BackgroundPaint;
import bibliothek.gui.dock.util.PaintableComponent;
import bibliothek.util.Path;
import java.awt.Component;
import java.awt.Graphics;

public abstract class BackgroundAlgorithm
implements BackgroundComponent {
    private Path kind;
    private String id;
    private DockController controller;
    private BackgroundPaint paint;

    public BackgroundAlgorithm(Path kind, String id) {
        this.kind = kind;
        this.id = id;
    }

    public void setController(DockController controller) {
        if (this.controller != null) {
            this.controller.getThemeManager().remove(this);
        }
        this.controller = controller;
        if (this.controller != null) {
            this.controller.getThemeManager().add(this.id, this.kind, ThemeManager.BACKGROUND_PAINT_TYPE, this);
        } else {
            this.set(null);
        }
    }

    public void repaint() {
        this.getComponent().repaint();
    }

    public void set(BackgroundPaint value) {
        if (this.paint != null) {
            this.paint.uninstall(this);
        }
        this.paint = value;
        if (this.paint != null) {
            this.paint.install(this);
        }
    }

    public BackgroundPaint getPaint() {
        return this.paint;
    }

    public void paint(PaintableComponent component, Graphics g) {
        if (this.paint == null) {
            component.paintBackground(g);
            component.paintForeground(g);
            component.paintBorder(g);
            component.paintChildren(g);
            component.paintOverlay(g);
        } else {
            Paintable paintable = new Paintable(component);
            paintable.paint(g);
        }
    }

    private class Paintable
    implements PaintableComponent {
        private PaintableComponent delegate;
        private boolean backgroundPainted = false;
        private boolean foregroundPainted = false;
        private boolean borderPainted = false;
        private boolean childrenPainted = false;
        private boolean overlayPainted = false;

        public Paintable(PaintableComponent delegate) {
            this.delegate = delegate;
        }

        public Component getComponent() {
            return this.delegate.getComponent();
        }

        public void paintBackground(Graphics g) {
            this.backgroundPainted = true;
            if (g != null) {
                this.delegate.paintBackground(g);
            }
        }

        public void paintForeground(Graphics g) {
            this.foregroundPainted = true;
            if (g != null) {
                this.delegate.paintForeground(g);
            }
        }

        public void paintBorder(Graphics g) {
            this.borderPainted = true;
            if (g != null) {
                this.delegate.paintBorder(g);
            }
        }

        public void paintChildren(Graphics g) {
            this.childrenPainted = true;
            if (g != null) {
                this.delegate.paintChildren(g);
            }
        }

        public void paintOverlay(Graphics g) {
            this.overlayPainted = true;
            if (g != null) {
                this.delegate.paintOverlay(g);
            }
        }

        public boolean isSolid() {
            return this.delegate.isSolid();
        }

        public boolean isTransparent() {
            return this.delegate.isTransparent();
        }

        public void paint(Graphics g) {
            BackgroundAlgorithm.this.paint.paint(BackgroundAlgorithm.this, this, g);
            if (!this.backgroundPainted) {
                this.paintBackground(g);
            }
            if (!this.foregroundPainted) {
                this.paintForeground(g);
            }
            if (!this.borderPainted) {
                this.paintBorder(g);
            }
            if (!this.childrenPainted) {
                this.paintChildren(g);
            }
            if (!this.overlayPainted) {
                this.paintOverlay(g);
            }
        }
    }
}

