/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.theme.bubble;

import bibliothek.extension.gui.dock.theme.bubble.BubbleColorAnimation;
import bibliothek.extension.gui.dock.theme.bubble.RoundButtonConnectable;
import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.action.DockAction;
import bibliothek.gui.dock.themes.basic.action.BasicDropDownButtonHandler;
import bibliothek.gui.dock.themes.basic.action.BasicDropDownButtonModel;
import bibliothek.gui.dock.themes.color.ActionColor;
import bibliothek.gui.dock.util.AbstractPaintableComponent;
import bibliothek.gui.dock.util.BackgroundComponent;
import bibliothek.gui.dock.util.BackgroundPaint;
import bibliothek.gui.dock.util.DockUtilities;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.geom.RoundRectangle2D;
import javax.swing.Icon;
import javax.swing.JComponent;

public class RoundDropDownButton
extends JComponent
implements RoundButtonConnectable {
    private BubbleColorAnimation animation = new BubbleColorAnimation();
    private BasicDropDownButtonModel model;
    private BasicDropDownButtonHandler handler;
    private Icon dropIcon;
    private Icon disabledDropIcon;
    private RoundActionColor[] colors;

    public RoundDropDownButton(BasicDropDownButtonHandler handler, Dockable dockable, DockAction action) {
        this.colors = new RoundActionColor[]{new RoundActionColor("action.dropdown", dockable, action, Color.WHITE), new RoundActionColor("action.dropdown.enabled", dockable, action, Color.LIGHT_GRAY), new RoundActionColor("action.dropdown.selected", dockable, action, Color.YELLOW), new RoundActionColor("action.dropdown.enabled.selected", dockable, action, Color.ORANGE), new RoundActionColor("action.dropdown.mouse.enabled", dockable, action, Color.RED), new RoundActionColor("action.dropdown.mouse.selected.enabled", dockable, action, new Color(128, 0, 0)), new RoundActionColor("action.dropdown.pressed.enabled", dockable, action, Color.BLUE), new RoundActionColor("action.dropdown.pressed.selected.enabled", dockable, action, Color.MAGENTA), new RoundActionColor("action.dropdown.focus", dockable, action, Color.DARK_GRAY), new RoundActionColor("action.dropdown.enabled.focus", dockable, action, Color.DARK_GRAY), new RoundActionColor("action.dropdown.selected.focus", dockable, action, Color.DARK_GRAY), new RoundActionColor("action.dropdown.enabled.selected.focus", dockable, action, Color.DARK_GRAY), new RoundActionColor("action.dropdown.mouse.enabled.focus", dockable, action, Color.DARK_GRAY), new RoundActionColor("action.dropdown.mouse.selected.enabled.focus", dockable, action, Color.DARK_GRAY), new RoundActionColor("action.dropdown.pressed.enabled.focus", dockable, action, Color.DARK_GRAY), new RoundActionColor("action.dropdown.pressed.selected.enabled.focus", dockable, action, Color.DARK_GRAY), new RoundActionColor("action.dropdown.line", dockable, action, Color.DARK_GRAY), new RoundActionColor("action.dropdown.line.enabled", dockable, action, Color.DARK_GRAY), new RoundActionColor("action.dropdown.line.selected", dockable, action, Color.DARK_GRAY), new RoundActionColor("action.dropdown.line.enabled.selected", dockable, action, Color.DARK_GRAY), new RoundActionColor("action.dropdown.line.mouse.enabled", dockable, action, Color.DARK_GRAY), new RoundActionColor("action.dropdown.line.mouse.selected.enabled", dockable, action, Color.DARK_GRAY), new RoundActionColor("action.dropdown.line.pressed.enabled", dockable, action, Color.DARK_GRAY), new RoundActionColor("action.dropdown.line.pressed.selected.enabled", dockable, action, Color.DARK_GRAY)};
        this.animation.addTask(new Runnable(){

            public void run() {
                RoundDropDownButton.this.repaint();
            }
        });
        this.handler = handler;
        this.dropIcon = this.createDropIcon();
        this.model = new BasicDropDownButtonModel(this, handler, handler){

            public void changed() {
                RoundDropDownButton.this.updateColors();
                RoundDropDownButton.this.revalidate();
                RoundDropDownButton.this.repaint();
            }

            protected boolean inDropDownArea(int x, int y) {
                return RoundDropDownButton.this.overDropIcon(x, y);
            }
        };
        this.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                RoundDropDownButton.this.repaint();
            }

            public void focusLost(FocusEvent e) {
                RoundDropDownButton.this.repaint();
            }
        });
        this.updateColors();
    }

    public void setController(DockController controller) {
        for (RoundActionColor color : this.colors) {
            color.connect(controller);
        }
        this.animation.kick();
    }

    public BasicDropDownButtonModel getModel() {
        return this.model;
    }

    public void updateUI() {
        this.disabledDropIcon = null;
        super.updateUI();
        if (this.handler != null) {
            this.handler.updateUI();
        }
    }

    public Dimension getPreferredSize() {
        if (this.isPreferredSizeSet()) {
            return super.getPreferredSize();
        }
        Dimension icon = this.model.getMaxIconSize();
        int w = Math.max(icon.width, 10);
        int h = Math.max(icon.height, 10);
        if (this.model.getOrientation().isHorizontal()) {
            return new Dimension((int)(1.5 * (double)w + 1.0 + 1.5 * (double)this.dropIcon.getIconWidth()), (int)(1.5 * (double)h));
        }
        return new Dimension((int)(1.5 * (double)w), (int)(1.5 * (double)h + 1.0 + 1.5 * (double)this.dropIcon.getIconHeight()));
    }

    public boolean contains(int x, int y) {
        if (!super.contains(x, y)) {
            return false;
        }
        int w = this.getWidth();
        int h = this.getHeight();
        RoundRectangle2D.Double rect = this.model.getOrientation().isHorizontal() ? new RoundRectangle2D.Double(0.0, 0.0, w, h, h, h) : new RoundRectangle2D.Double(0.0, 0.0, w, h, w, w);
        return rect.contains(x, y);
    }

    protected void paintComponent(Graphics g) {
        BasicDropDownButtonModel model = this.getModel();
        BackgroundPaint paint = model.getBackground();
        BackgroundComponent component = model.getBackgroundComponent();
        AbstractPaintableComponent paintable = new AbstractPaintableComponent(component, this, paint){

            protected void foreground(Graphics g) {
                RoundDropDownButton.this.doPaintForeground(g);
            }

            protected void background(Graphics g) {
                RoundDropDownButton.this.doPaintBackground(g);
            }

            protected void border(Graphics g) {
            }

            protected void children(Graphics g) {
            }

            protected void overlay(Graphics g) {
            }

            public boolean isSolid() {
                return false;
            }

            public boolean isTransparent() {
                return false;
            }
        };
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        paintable.paint(g2);
        g2.dispose();
    }

    private void doPaintBackground(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        int x = 0;
        int y = 0;
        int w = this.getWidth();
        int h = this.getHeight();
        if (this.model.getOrientation().isHorizontal()) {
            g2.setColor(this.animation.getColor("background"));
            g2.fillRoundRect(x, y, w, h, h, h);
        } else {
            g2.setColor(this.animation.getColor("background"));
            g2.fillRoundRect(x, y, w, h, w, w);
        }
    }

    private void doPaintForeground(Graphics g) {
        int dropIconHeight;
        Icon drop = this.dropIcon;
        if (!this.isEnabled()) {
            if (this.disabledDropIcon == null) {
                this.disabledDropIcon = DockUtilities.disabledIcon(this, this.dropIcon);
            }
            drop = this.disabledDropIcon;
        }
        Graphics2D g2 = (Graphics2D)g;
        int x = 0;
        int y = 0;
        int w = this.getWidth();
        int h = this.getHeight();
        Dimension size = this.model.getMaxIconSize();
        Icon icon = this.model.getPaintIcon();
        int iconWidth = size.width < 10 ? 10 : size.width;
        int iconHeight = size.height < 10 ? 10 : size.height;
        int dropIconWidth = drop == null ? 5 : drop.getIconWidth();
        int n = dropIconHeight = drop == null ? 5 : drop.getIconHeight();
        if (this.model.getOrientation().isHorizontal()) {
            g2.setColor(this.animation.getColor("mouse"));
            int mx = x + (int)(0.625 * (double)iconWidth + 0.5 * ((double)w - 1.25 * (double)dropIconWidth));
            g2.drawLine(mx, y + 1, mx, y + h - 2);
            if (icon != null) {
                icon.paintIcon(this, g, (int)((double)x + 0.25 * (double)iconWidth), y + (h - iconHeight) / 2);
            }
            if (drop != null) {
                drop.paintIcon(this, g, (int)((double)(x + w) - 1.25 * (double)dropIconWidth), y + (h - dropIconHeight) / 2);
            }
            if (this.hasFocus() && this.isFocusable() && this.isEnabled()) {
                Stroke stroke = g2.getStroke();
                g2.setStroke(new BasicStroke(3.0f));
                g2.setColor(this.animation.getColor("focus"));
                g2.drawRoundRect(x + 1, y + 1, w - 3, h - 3, h, h);
                g2.setStroke(stroke);
            }
        } else {
            g2.setColor(this.animation.getColor("mouse"));
            int my = y + (int)(0.625 * (double)iconHeight + 0.5 * ((double)h - 1.25 * (double)dropIconHeight));
            g2.drawLine(x + 1, my, x + w - 2, my);
            if (icon != null) {
                icon.paintIcon(this, g, x + (w - iconWidth) / 2, (int)((double)y + 0.25 * (double)iconHeight));
            }
            if (drop != null) {
                drop.paintIcon(this, g, x + (w - dropIconWidth) / 2, (int)((double)(y + h) - 1.25 * (double)dropIconHeight));
            }
            if (this.hasFocus() && this.isFocusable() && this.isEnabled()) {
                Stroke stroke = g2.getStroke();
                g2.setStroke(new BasicStroke(3.0f));
                g2.setColor(this.animation.getColor("focus"));
                g2.drawRoundRect(x + 1, y + 1, w - 3, h - 3, w, w);
                g2.setStroke(stroke);
            }
        }
    }

    protected Icon createDropIcon() {
        return new Icon(){

            public int getIconHeight() {
                return 7;
            }

            public int getIconWidth() {
                return 7;
            }

            public void paintIcon(Component c, Graphics g, int x, int y) {
                g.setColor(RoundDropDownButton.this.getForeground());
                g.drawLine(++x, y + 1, x + 4, y + 1);
                g.drawLine(x + 1, y + 2, x + 3, y + 2);
                g.drawLine(x + 2, y + 3, x + 2, y + 3);
            }
        };
    }

    public boolean overDropIcon(int x, int y) {
        int dropIconHeight;
        if (!this.contains(x, y)) {
            return false;
        }
        int rx = 0;
        int ry = 0;
        int rw = this.getWidth();
        int rh = this.getHeight();
        Dimension icon = this.model.getMaxIconSize();
        int iconWidth = icon.width < 10 ? 10 : icon.width;
        int iconHeight = icon.height < 10 ? 10 : icon.height;
        int dropIconWidth = this.dropIcon == null ? 5 : this.dropIcon.getIconWidth();
        int n = dropIconHeight = this.dropIcon == null ? 5 : this.dropIcon.getIconHeight();
        if (this.model.getOrientation().isHorizontal()) {
            int mx = rx + (int)(0.625 * (double)iconWidth + 0.5 * ((double)rw - 1.25 * (double)dropIconWidth));
            return x >= mx;
        }
        int my = ry + (int)(0.625 * (double)iconHeight + 0.5 * ((double)rh - 1.25 * (double)dropIconHeight));
        return y >= my;
    }

    public void updateColors() {
        String background;
        String postfix = "";
        boolean selected = this.model.isSelected();
        boolean enabled = this.model.isEnabled();
        boolean pressed = this.model.isMousePressed();
        boolean entered = this.model.isMouseInside();
        boolean mouseOverDrop = this.model.isMouseOverDropDown();
        if (selected) {
            postfix = ".selected";
        }
        if (enabled) {
            postfix = postfix + ".enabled";
        }
        String mouse = mouseOverDrop && enabled ? "dropdown.line" : "dropdown";
        if (pressed && enabled) {
            background = "action.dropdown.pressed" + postfix;
            mouse = "action." + mouse + ".pressed" + postfix;
        } else if (entered && enabled) {
            background = "action.dropdown.mouse" + postfix;
            mouse = "action." + mouse + ".mouse" + postfix;
        } else {
            background = "action.dropdown" + postfix;
            mouse = "action." + mouse + postfix;
        }
        String focus = background + ".focus";
        for (RoundActionColor color : this.colors) {
            if (background.equals(color.getId())) {
                this.animation.putColor("background", (Color)color.value());
            }
            if (mouse.equals(color.getId())) {
                this.animation.putColor("mouse", (Color)color.value());
            }
            if (!focus.equals(color.getId())) continue;
            this.animation.putColor("focus", (Color)color.value());
        }
    }

    private class RoundActionColor
    extends ActionColor {
        public RoundActionColor(String id, Dockable dockable, DockAction action, Color backup) {
            super(id, dockable, action, backup);
        }

        protected void changed(Color oldColor, Color newColor) {
            RoundDropDownButton.this.updateColors();
        }
    }
}

