/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.text.translate;

import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.EnumSet;
import org.apache.commons.lang3.text.translate.CharSequenceTranslator;

public class UnicodeUnescaper
extends CharSequenceTranslator {
    private final EnumSet<OPTION> options;

    public UnicodeUnescaper(OPTION ... options) {
        this.options = options.length > 0 ? EnumSet.copyOf(Arrays.asList(options)) : null;
    }

    public boolean isSet(OPTION opt) {
        return this.options == null ? false : this.options.contains((Object)opt);
    }

    public int translate(CharSequence input, int index, Writer out) throws IOException {
        if (input.charAt(index) == '\\' && index + 1 < input.length() && input.charAt(index + 1) == 'u') {
            int i = 2;
            while (index + i < input.length() && input.charAt(index + i) == 'u') {
                ++i;
            }
            if (this.isSet(OPTION.escapePlus) && index + i < input.length() && input.charAt(index + i) == '+') {
                ++i;
            }
            if (index + i + 4 <= input.length()) {
                CharSequence unicode = input.subSequence(index + i, index + i + 4);
                try {
                    int value = Integer.parseInt(((Object)unicode).toString(), 16);
                    out.write((char)value);
                }
                catch (NumberFormatException nfe) {
                    throw new IllegalArgumentException("Unable to parse unicode value: " + unicode, nfe);
                }
                return i + 4;
            }
            throw new IllegalArgumentException("Less than 4 hex digits in unicode value: '" + input.subSequence(index, input.length()) + "' due to end of CharSequence");
        }
        return 0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OPTION {
        escapePlus;

    }
}

