/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.group;

import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.StackDockStation;
import bibliothek.gui.dock.common.group.CGroupBehavior;
import bibliothek.gui.dock.common.group.CGroupMovement;
import bibliothek.gui.dock.common.group.SingleGroupMovement;
import bibliothek.gui.dock.common.group.StackGroupMovement;
import bibliothek.gui.dock.common.intern.CDockable;
import bibliothek.gui.dock.common.intern.CommonDockable;
import bibliothek.gui.dock.common.mode.ExtendedMode;
import bibliothek.gui.dock.facile.mode.LocationMode;
import bibliothek.gui.dock.facile.mode.LocationModeManager;
import bibliothek.gui.dock.facile.mode.status.ExtendedModeEnablement;
import bibliothek.gui.dock.util.DockUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StackGroupBehavior
implements CGroupBehavior {
    @Override
    public CGroupMovement prepare(LocationModeManager<? extends LocationMode> manager, Dockable dockable, ExtendedMode target) {
        if (this.isGrouped(dockable, target, manager)) {
            return new StackGroupMovement((StackDockStation)dockable.getDockParent(), dockable, target);
        }
        return new SingleGroupMovement(dockable, target);
    }

    private boolean isGrouped(Dockable dockable, ExtendedMode target, LocationModeManager<?> manager) {
        if (target == ExtendedMode.MAXIMIZED) {
            return false;
        }
        DockStation parent = dockable.getDockParent();
        if (parent instanceof StackDockStation) {
            int n = parent.getDockableCount();
            for (int i = 0; i < n; ++i) {
                if (manager.isModeAvailable(parent.getDockable(i), target)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public Dockable getGroupElement(Dockable dockable, ExtendedMode mode) {
        DockStation parent = dockable.getDockParent();
        if (parent instanceof StackDockStation) {
            int n = parent.getDockableCount();
            for (int i = 0; i < n; ++i) {
                CDockable fdock;
                Dockable check = parent.getDockable(i);
                if (check == dockable || !(check instanceof CommonDockable) || (fdock = ((CommonDockable)check).getDockable()).isMaximizable()) continue;
                return dockable;
            }
            return (StackDockStation)parent;
        }
        return dockable;
    }

    @Override
    public Dockable getReplaceElement(Dockable old, Dockable dockable, ExtendedMode mode) {
        if (old == dockable) {
            return null;
        }
        if (!DockUtilities.isAncestor(old, dockable)) {
            return null;
        }
        DockStation station = old.asDockStation();
        if (station == null) {
            return old;
        }
        if (station.getDockableCount() == 2) {
            if (station.getDockable(0) == dockable) {
                return station.getDockable(1);
            }
            if (station.getDockable(1) == dockable) {
                return station.getDockable(0);
            }
        }
        return old;
    }

    @Override
    public boolean shouldForwardActions(DockStation station, Dockable dockable, ExtendedMode mode, ExtendedModeEnablement enablement) {
        int n = station.getDockableCount();
        for (int i = 0; i < n; ++i) {
            Dockable child = station.getDockable(i);
            if (enablement.isAvailable(child, mode)) continue;
            return false;
        }
        return true;
    }
}

