/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.themes.basic.action.buttons;

import bibliothek.gui.dock.themes.basic.action.BasicButtonModel;
import bibliothek.gui.dock.themes.basic.action.BasicButtonModelAdapter;
import bibliothek.gui.dock.themes.border.BorderModifier;
import bibliothek.gui.dock.util.AbstractPaintableComponent;
import bibliothek.gui.dock.util.BackgroundComponent;
import bibliothek.gui.dock.util.BackgroundPaint;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.border.Border;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MiniButton<M extends BasicButtonModel>
extends JComponent {
    public static final String BORDER_KEY_NORMAL = "dock.border.action.miniButton.normal";
    public static final String BORDER_KEY_NORMAL_SELECTED = "dock.border.action.miniButton.normal.selected";
    public static final String BORDER_KEY_MOUSE_OVER = "dock.border.action.miniButton.mouseOver";
    public static final String BORDER_KEY_MOUSE_OVER_SELECTED = "dock.border.action.miniButton.mouseOver.selected";
    public static final String BORDER_KEY_MOUSE_PRESSED = "dock.border.action.miniButton.mousePressed";
    public static final String BORDER_KEY_MOUSE_PRESSED_SELECTED = "dock.border.action.miniButton.mousePressed.selected";
    private Border normalBorder;
    private Border mouseOverBorder;
    private Border mousePressedBorder;
    private Border normalSelectedBorder;
    private Border mouseOverSelectedBorder;
    private Border mousePressedSelectedBorder;
    private M model;
    private BasicButtonModelAdapter listener = new BasicButtonModelAdapter(){

        public void mouseInside(BasicButtonModel model, boolean mouseInside) {
            MiniButton.this.updateBorder();
        }

        public void mousePressed(BasicButtonModel model, boolean mousePressed) {
            if (mousePressed) {
                MiniButton.this.requestFocusInWindow();
            }
            MiniButton.this.updateBorder();
        }

        public void enabledStateChanged(BasicButtonModel model, boolean enabled) {
            MiniButton.this.updateBorder();
        }

        public void selectedStateChanged(BasicButtonModel model, boolean selected) {
            MiniButton.this.updateBorder();
        }

        public void borderChanged(BasicButtonModel model, String key, BorderModifier oldBorder, BorderModifier newBorder) {
            MiniButton.this.updateBorder();
        }
    };

    public MiniButton(M model) {
        this.model = model;
        this.mousePressedBorder = BorderFactory.createBevelBorder(1);
        this.mouseOverBorder = BorderFactory.createBevelBorder(0);
        this.normalSelectedBorder = this.mousePressedBorder;
        this.mouseOverSelectedBorder = this.mousePressedBorder;
        this.mousePressedSelectedBorder = this.mouseOverBorder;
        this.setFocusable(true);
        this.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                MiniButton.this.repaint();
            }

            public void focusLost(FocusEvent e) {
                MiniButton.this.repaint();
            }
        });
    }

    protected void setModel(M model) {
        if (this.model != null) {
            ((BasicButtonModel)this.model).removeListener(this.listener);
        }
        this.model = model;
        if (this.model != null) {
            ((BasicButtonModel)this.model).addListener(this.listener);
        }
        this.updateBorder();
    }

    public M getModel() {
        return this.model;
    }

    public Border getMouseOverBorder() {
        return this.mouseOverBorder;
    }

    public void setMouseOverBorder(Border mouseOverBorder) {
        this.mouseOverBorder = mouseOverBorder;
        this.updateBorder();
    }

    public Border getMousePressedBorder() {
        return this.mousePressedBorder;
    }

    public void setMousePressedBorder(Border mousePressedBorder) {
        this.mousePressedBorder = mousePressedBorder;
        this.updateBorder();
    }

    public Border getNormalBorder() {
        return this.normalBorder;
    }

    public void setNormalBorder(Border normalBorder) {
        this.normalBorder = normalBorder;
        this.updateBorder();
    }

    public Border getNormalSelectedBorder() {
        return this.normalSelectedBorder;
    }

    public void setNormalSelectedBorder(Border normalSelectedBorder) {
        this.normalSelectedBorder = normalSelectedBorder;
        this.updateBorder();
    }

    public Border getMouseOverSelectedBorder() {
        return this.mouseOverSelectedBorder;
    }

    public void setMouseOverSelectedBorder(Border mouseOverSelectedBorder) {
        this.mouseOverSelectedBorder = mouseOverSelectedBorder;
        this.updateBorder();
    }

    public Border getMousePressedSelectedBorder() {
        return this.mousePressedSelectedBorder;
    }

    public void setMousePressedSelectedBorder(Border mousePressedSelectedBorder) {
        this.mousePressedSelectedBorder = mousePressedSelectedBorder;
        this.updateBorder();
    }

    @Override
    public void paint(Graphics g) {
        BackgroundPaint paint = ((BasicButtonModel)this.model).getBackground();
        BackgroundComponent component = ((BasicButtonModel)this.model).getBackgroundComponent();
        AbstractPaintableComponent paintable = new AbstractPaintableComponent(component, this, paint){

            protected void background(Graphics g) {
            }

            protected void foreground(Graphics g) {
                MiniButton.this.doPaintForeground(g);
            }

            protected void border(Graphics g) {
                MiniButton.this.doPaintBorder(g);
            }

            protected void children(Graphics g) {
            }

            protected void overlay(Graphics g) {
            }

            public boolean isSolid() {
                return false;
            }

            public boolean isTransparent() {
                return false;
            }
        };
        paintable.paint(g);
    }

    private void doPaintForeground(Graphics g) {
        Icon icon = ((BasicButtonModel)this.model).getPaintIcon();
        if (icon != null) {
            this.paintIcon(icon, g);
        }
        if (this.isFocusOwner() && this.isFocusable() && this.isEnabled()) {
            this.paintFocus(g);
        }
    }

    private void doPaintBorder(Graphics g) {
        Border border = this.getBorder();
        if (border != null) {
            border.paintBorder(this, g, 0, 0, this.getWidth(), this.getHeight());
        }
    }

    protected void paintIcon(Icon icon, Graphics g) {
        Insets max = this.getMaxBorderInsets();
        icon.paintIcon(this, g, max.left + (this.getWidth() - max.left - max.right - icon.getIconWidth()) / 2, max.top + (this.getHeight() - max.top - max.bottom - icon.getIconHeight()) / 2);
    }

    protected void paintFocus(Graphics g) {
        g.setColor(this.getForeground());
        Insets insets = this.getMaxBorderInsets();
        int x = insets.left;
        int y = insets.right;
        int w = this.getWidth() - insets.left - insets.right;
        int h = this.getHeight() - insets.top - insets.bottom;
        --h;
        g.drawLine(x, y, x + 2, y);
        g.drawLine(x, y + 1, x + 1, y + 1);
        g.drawLine(x, y + 2, x, y + 2);
        g.drawLine(x + --w, y, x + w - 2, y);
        g.drawLine(x + w, y + 1, x + w - 1, y + 1);
        g.drawLine(x + w, y + 2, x + w, y + 2);
        g.drawLine(x + w, y + h, x + w - 2, y + h);
        g.drawLine(x + w, y + h - 1, x + w - 1, y + h - 1);
        g.drawLine(x + w, y + h - 2, x + w, y + h - 2);
        g.drawLine(x, y + h, x + 2, y + h);
        g.drawLine(x, y + h - 1, x + 1, y + h - 1);
        g.drawLine(x, y + h - 2, x, y + h - 2);
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.isPreferredSizeSet()) {
            return super.getPreferredSize();
        }
        Insets max = this.getMaxBorderInsets();
        Dimension size = ((BasicButtonModel)this.model).getMaxIconSize();
        size.width = Math.max(size.width, 16);
        size.height = Math.max(size.height, 16);
        size.width += max.left + max.right + 2;
        size.height += max.top + max.bottom + 2;
        return size;
    }

    protected Insets getMaxBorderInsets() {
        Insets max = new Insets(0, 0, 0, 0);
        for (int i = 0; i < 6; ++i) {
            Border border = null;
            switch (i) {
                case 0: {
                    border = this.getBorder(this.getNormalBorder(), BORDER_KEY_NORMAL);
                    break;
                }
                case 1: {
                    border = this.getBorder(this.getMouseOverBorder(), BORDER_KEY_MOUSE_OVER);
                    break;
                }
                case 2: {
                    border = this.getBorder(this.getMousePressedBorder(), BORDER_KEY_MOUSE_PRESSED);
                    break;
                }
                case 3: {
                    border = this.getBorder(this.getNormalSelectedBorder(), BORDER_KEY_NORMAL_SELECTED);
                    break;
                }
                case 4: {
                    border = this.getBorder(this.getMouseOverSelectedBorder(), BORDER_KEY_MOUSE_OVER_SELECTED);
                    break;
                }
                case 5: {
                    border = this.getBorder(this.getMousePressedSelectedBorder(), BORDER_KEY_MOUSE_PRESSED_SELECTED);
                }
            }
            if (border == null) continue;
            Insets insets = border.getBorderInsets(this);
            max.left = Math.max(max.left, insets.left);
            max.right = Math.max(max.right, insets.right);
            max.top = Math.max(max.top, insets.top);
            max.bottom = Math.max(max.bottom, insets.bottom);
        }
        return max;
    }

    protected void updateBorder() {
        if (((BasicButtonModel)this.model).isEnabled() && ((BasicButtonModel)this.model).isMousePressed()) {
            if (((BasicButtonModel)this.model).isSelected()) {
                this.setBorder(this.getBorder(this.getMousePressedSelectedBorder(), BORDER_KEY_MOUSE_PRESSED_SELECTED));
            } else {
                this.setBorder(this.getBorder(this.getMousePressedBorder(), BORDER_KEY_MOUSE_PRESSED));
            }
        } else if (((BasicButtonModel)this.model).isEnabled() && ((BasicButtonModel)this.model).isMouseInside()) {
            if (((BasicButtonModel)this.model).isSelected()) {
                this.setBorder(this.getBorder(this.getMouseOverSelectedBorder(), BORDER_KEY_MOUSE_OVER_SELECTED));
            } else {
                this.setBorder(this.getBorder(this.getMouseOverBorder(), BORDER_KEY_MOUSE_OVER));
            }
        } else if (((BasicButtonModel)this.model).isSelected()) {
            this.setBorder(this.getBorder(this.getNormalSelectedBorder(), BORDER_KEY_NORMAL_SELECTED));
        } else {
            this.setBorder(this.getBorder(this.getNormalBorder(), BORDER_KEY_NORMAL));
        }
    }

    private Border getBorder(Border defaultBorder, String key) {
        BorderModifier modifier = ((BasicButtonModel)this.model).getBorder(key);
        if (modifier == null) {
            return defaultBorder;
        }
        return modifier.modify(defaultBorder);
    }
}

