/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.themes.basic.action.dropdown;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.action.StandardDockAction;
import bibliothek.gui.dock.action.StandardDropDownItemAction;
import bibliothek.gui.dock.action.dropdown.DropDownView;
import bibliothek.gui.dock.event.StandardDockActionListener;
import bibliothek.gui.dock.themes.basic.action.dropdown.DropDownViewItem;
import bibliothek.gui.dock.themes.basic.action.menu.AbstractMenuHandler;
import java.awt.event.ActionListener;
import java.util.Set;
import javax.swing.JMenuItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDropDownHandler<S extends StandardDropDownItemAction>
extends AbstractMenuHandler<JMenuItem, S>
implements DropDownViewItem {
    private DropDownView view;
    private Listener listener = new Listener();

    public AbstractDropDownHandler(S s, Dockable dockable, JMenuItem jMenuItem) {
        super(s, dockable, jMenuItem);
    }

    public DropDownView getView() {
        return this.view;
    }

    @Override
    public void addActionListener(ActionListener actionListener) {
        this.item.addActionListener(actionListener);
    }

    @Override
    public boolean isSelectable() {
        return ((StandardDropDownItemAction)this.action).isDropDownSelectable(this.dockable);
    }

    @Override
    public boolean isTriggerable(boolean bl) {
        return ((StandardDropDownItemAction)this.action).isDropDownTriggerable(this.dockable, bl);
    }

    @Override
    public void removeActionListener(ActionListener actionListener) {
        this.item.removeActionListener(actionListener);
    }

    @Override
    public void setView(DropDownView dropDownView) {
        this.view = dropDownView;
        if (dropDownView != null) {
            dropDownView.setText(((StandardDropDownItemAction)this.action).getText(this.dockable));
            dropDownView.setTooltip(((StandardDropDownItemAction)this.action).getTooltipText(this.dockable));
            dropDownView.setIcon(((StandardDropDownItemAction)this.action).getIcon(this.dockable));
            dropDownView.setDisabledIcon(((StandardDropDownItemAction)this.action).getDisabledIcon(this.dockable));
            dropDownView.setEnabled(((StandardDropDownItemAction)this.action).isEnabled(this.dockable));
        }
    }

    @Override
    public void bind() {
        super.bind();
        ((StandardDropDownItemAction)this.action).addDockActionListener(this.listener);
        if (this.view != null) {
            this.view.setText(((StandardDropDownItemAction)this.action).getText(this.dockable));
            this.view.setTooltip(((StandardDropDownItemAction)this.action).getTooltipText(this.dockable));
            this.view.setIcon(((StandardDropDownItemAction)this.action).getIcon(this.dockable));
            this.view.setDisabledIcon(((StandardDropDownItemAction)this.action).getDisabledIcon(this.dockable));
            this.view.setEnabled(((StandardDropDownItemAction)this.action).isEnabled(this.dockable));
        }
    }

    @Override
    public void unbind() {
        ((StandardDropDownItemAction)this.action).removeDockActionListener(this.listener);
        super.unbind();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Listener
    implements StandardDockActionListener {
        private Listener() {
        }

        @Override
        public void actionEnabledChanged(StandardDockAction standardDockAction, Set<Dockable> set) {
            if (AbstractDropDownHandler.this.view != null && set.contains(AbstractDropDownHandler.this.dockable)) {
                AbstractDropDownHandler.this.view.setEnabled(standardDockAction.isEnabled(AbstractDropDownHandler.this.dockable));
            }
        }

        @Override
        public void actionIconChanged(StandardDockAction standardDockAction, Set<Dockable> set) {
            if (AbstractDropDownHandler.this.view != null && set.contains(AbstractDropDownHandler.this.dockable)) {
                AbstractDropDownHandler.this.view.setIcon(standardDockAction.getIcon(AbstractDropDownHandler.this.dockable));
            }
        }

        @Override
        public void actionDisabledIconChanged(StandardDockAction standardDockAction, Set<Dockable> set) {
            if (AbstractDropDownHandler.this.view != null && set.contains(AbstractDropDownHandler.this.dockable)) {
                AbstractDropDownHandler.this.view.setDisabledIcon(standardDockAction.getDisabledIcon(AbstractDropDownHandler.this.dockable));
            }
        }

        @Override
        public void actionTextChanged(StandardDockAction standardDockAction, Set<Dockable> set) {
            if (AbstractDropDownHandler.this.view != null && set.contains(AbstractDropDownHandler.this.dockable)) {
                AbstractDropDownHandler.this.view.setText(standardDockAction.getText(AbstractDropDownHandler.this.dockable));
            }
        }

        @Override
        public void actionTooltipTextChanged(StandardDockAction standardDockAction, Set<Dockable> set) {
            if (AbstractDropDownHandler.this.view != null && set.contains(AbstractDropDownHandler.this.dockable)) {
                AbstractDropDownHandler.this.view.setTooltip(standardDockAction.getTooltipText(AbstractDropDownHandler.this.dockable));
            }
        }
    }
}

