/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.themes.basic;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.FlapDockStation;
import bibliothek.gui.dock.event.DockTitleEvent;
import bibliothek.gui.dock.themes.color.TitleColor;
import bibliothek.gui.dock.themes.font.TitleFont;
import bibliothek.gui.dock.title.AbstractDockTitle;
import bibliothek.gui.dock.title.DockTitleVersion;
import bibliothek.util.Condition;
import java.awt.Color;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.event.MouseInputAdapter;

public class BasicButtonDockTitle
extends AbstractDockTitle {
    private boolean mousePressed = false;
    private boolean selected = false;
    private FlapDockStation.ButtonContent behavior;
    private TitleColor activeColor = new BasicTitleColor("title.flap.active", null);
    private TitleColor activeTextColor = new BasicTitleColor("title.flap.active.text", null);
    private TitleColor inactiveColor = new BasicTitleColor("title.flap.inactive", null);
    private TitleColor inactiveTextColor = new BasicTitleColor("title.flap.inactive.text", null);
    private TitleColor selectedColor = new BasicTitleColor("title.flap.selected", null);
    private TitleColor selectedTextColor = new BasicTitleColor("title.flap.selected.text", null);

    public BasicButtonDockTitle(Dockable dockable, DockTitleVersion dockTitleVersion) {
        this.behavior = FlapDockStation.ButtonContent.THEME_DEPENDENT;
        if (dockTitleVersion != null) {
            this.behavior = dockTitleVersion.getController().getProperties().get(FlapDockStation.BUTTON_CONTENT);
        }
        this.init(dockable, dockTitleVersion, this.behavior.showActions(true));
        this.setBorder(BorderFactory.createBevelBorder(0));
        this.addMouseInputListener(new MouseInputAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                BasicButtonDockTitle.this.mousePressed = (mouseEvent.getModifiersEx() & 0x400) != 0;
                BasicButtonDockTitle.this.changeBorder();
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                BasicButtonDockTitle.this.mousePressed = (mouseEvent.getModifiersEx() & 0x400) != 0;
                BasicButtonDockTitle.this.changeBorder();
            }
        });
        this.addColor(this.activeColor);
        this.addColor(this.activeTextColor);
        this.addColor(this.inactiveColor);
        this.addColor(this.inactiveTextColor);
        this.addColor(this.selectedColor);
        this.addColor(this.selectedTextColor);
        this.addConditionalFont("title.flap.active", TitleFont.KIND_FLAP_BUTTON_FONT, new Condition(){

            public boolean getState() {
                return BasicButtonDockTitle.this.isActive();
            }
        }, null);
        this.addConditionalFont("title.flap.selected", TitleFont.KIND_FLAP_BUTTON_FONT, new Condition(){

            public boolean getState() {
                return BasicButtonDockTitle.this.isSelected();
            }
        }, null);
        this.addConditionalFont("title.flap.inactive", TitleFont.KIND_FLAP_BUTTON_FONT, new Condition(){

            public boolean getState() {
                return !BasicButtonDockTitle.this.isActive();
            }
        }, null);
    }

    protected void updateIcon() {
        String string = this.getDockable().getTitleText();
        if (this.behavior.showIcon(string != null && string.length() > 0, true)) {
            super.updateIcon();
        } else {
            this.setIcon(null);
        }
    }

    protected void updateText() {
        if (this.behavior.showText(this.getDockable().getTitleIcon() != null, true)) {
            super.updateText();
        } else {
            this.setText("");
        }
    }

    public void setActive(boolean bl) {
        if (bl != this.isActive()) {
            super.setActive(bl);
            this.selected = bl;
            this.updateLayout();
        }
    }

    public void changed(DockTitleEvent dockTitleEvent) {
        super.setActive(dockTitleEvent.isActive());
        this.selected = dockTitleEvent.isActive() || dockTitleEvent.isPreferred();
        this.updateLayout();
    }

    public Point getPopupLocation(Point point, boolean bl) {
        if (bl) {
            return point;
        }
        return null;
    }

    protected boolean isMousePressed() {
        return this.mousePressed;
    }

    public boolean isSelected() {
        return this.selected;
    }

    protected void updateLayout() {
        this.changeBorder();
        this.updateColors();
        this.updateFonts();
    }

    protected void changeBorder() {
        if (this.selected ^ this.mousePressed) {
            this.setBorder(BorderFactory.createBevelBorder(1));
        } else {
            this.setBorder(BorderFactory.createBevelBorder(0));
        }
    }

    protected void updateColors() {
        if (this.isActive()) {
            this.setBackground(this.activeColor.color());
            this.setForeground(this.activeTextColor.color());
        } else if (this.selected) {
            this.setBackground(this.selectedColor.color());
            this.setForeground(this.selectedTextColor.color());
        } else {
            this.setBackground(this.inactiveColor.color());
            this.setForeground(this.inactiveTextColor.color());
        }
    }

    public Color getActiveTextColor() {
        return this.activeTextColor.color();
    }

    public void setActiveTextColor(Color color) {
        this.activeTextColor.setValue(color);
    }

    public Color getActiveColor() {
        return this.activeColor.color();
    }

    public void setActiveColor(Color color) {
        this.activeColor.setValue(color);
    }

    public Color getSelectedTextColor() {
        return this.selectedTextColor.color();
    }

    public void setSelectedTextColor(Color color) {
        this.selectedTextColor.setValue(color);
    }

    public Color getSelectedColor() {
        return this.selectedColor.color();
    }

    public void setSelectedColor(Color color) {
        this.selectedColor.setValue(color);
    }

    public Color getInactiveTextColor() {
        return this.inactiveTextColor.color();
    }

    public void setInactiveTextColor(Color color) {
        this.inactiveTextColor.setValue(color);
    }

    public Color getInactiveColor() {
        return this.inactiveColor.color();
    }

    public void setInactiveColor(Color color) {
        this.inactiveColor.setValue(color);
    }

    private class BasicTitleColor
    extends TitleColor {
        public BasicTitleColor(String string, Color color) {
            super(string, TitleColor.KIND_FLAP_BUTTON_COLOR, BasicButtonDockTitle.this, color);
        }

        protected void changed(Color color, Color color2) {
            BasicButtonDockTitle.this.updateColors();
        }
    }
}

