/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.split;

import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.station.split.Leaf;
import bibliothek.gui.dock.station.split.Node;
import bibliothek.gui.dock.station.split.Placeholder;
import bibliothek.gui.dock.station.split.Root;
import bibliothek.gui.dock.station.split.SplitDockAccess;
import bibliothek.gui.dock.station.split.SplitNode;
import bibliothek.gui.dock.station.split.SplitNodeVisitor;
import bibliothek.gui.dock.station.support.PlaceholderMap;
import bibliothek.gui.dock.station.support.PlaceholderStrategy;
import bibliothek.util.Path;
import java.util.ArrayList;
import java.util.HashSet;

public class SplitPlaceholderSet {
    private SplitDockAccess access;

    public SplitPlaceholderSet(SplitDockAccess splitDockAccess) {
        this.access = splitDockAccess;
    }

    public void set(SplitNode splitNode, Dockable dockable, SplitNode ... splitNodeArray) {
        Path path;
        PlaceholderStrategy placeholderStrategy = this.access.getOwner().getPlaceholderStrategy();
        if (placeholderStrategy != null && (path = placeholderStrategy.getPlaceholderFor(dockable)) != null) {
            this.set(splitNode, path, splitNodeArray);
        }
    }

    public void set(final SplitNode splitNode, final Path path, SplitNode ... splitNodeArray) {
        final ArrayList arrayList = new ArrayList();
        Root root = this.access.getOwner().getRoot();
        root.visit(new SplitNodeVisitor(){

            public void handleRoot(Root root) {
                this.handle(root);
            }

            public void handlePlaceholder(Placeholder placeholder) {
                this.handle(placeholder);
            }

            public void handleNode(Node node) {
                this.handle(node);
            }

            public void handleLeaf(Leaf leaf) {
                this.handle(leaf);
            }

            private void handle(SplitNode splitNode2) {
                if (splitNode2 != splitNode) {
                    splitNode2.removePlaceholder(path);
                    PlaceholderMap placeholderMap = splitNode2.getPlaceholderMap();
                    if (placeholderMap != null) {
                        placeholderMap.removeAll(path, true);
                    }
                    if (!splitNode2.isOfUse()) {
                        arrayList.add(splitNode2);
                    }
                }
            }
        });
        if (splitNode != null) {
            splitNode.addPlaceholder(path);
        }
        if (this.access.isTreeAutoCleanupEnabled()) {
            for (SplitNode splitNode2 : splitNodeArray) {
                arrayList.remove(splitNode2);
            }
            for (SplitNode splitNode3 : arrayList) {
                splitNode3.delete(true);
            }
        }
    }

    public void removeDoublePlaceholders(final SplitNode splitNode, PlaceholderMap placeholderMap) {
        final HashSet<Path> hashSet = new HashSet<Path>();
        final PlaceholderStrategy placeholderStrategy = this.access.getOwner().getPlaceholderStrategy();
        Root root = this.access.getOwner().getRoot();
        root.visit(new SplitNodeVisitor(){

            public void handleRoot(Root root) {
                this.handle(root);
            }

            public void handlePlaceholder(Placeholder placeholder) {
                this.handle(placeholder);
            }

            public void handleNode(Node node) {
                this.handle(node);
            }

            public void handleLeaf(Leaf leaf) {
                if (leaf != splitNode) {
                    this.handle(leaf);
                    this.handle(leaf.getDockable());
                }
            }

            private void handle(SplitNode splitNode2) {
                if (splitNode2 != splitNode) {
                    for (Path path : splitNode.getPlaceholders()) {
                        hashSet.add(path);
                    }
                }
            }

            private void handle(Dockable dockable) {
                if (placeholderStrategy != null && dockable != null) {
                    DockStation dockStation;
                    Path path = placeholderStrategy.getPlaceholderFor(dockable);
                    if (path != null) {
                        hashSet.add(path);
                    }
                    if ((dockStation = dockable.asDockStation()) != null) {
                        int n = dockStation.getDockableCount();
                        for (int i = 0; i < n; ++i) {
                            this.handle(dockStation.getDockable(i));
                        }
                    }
                }
            }
        });
        placeholderMap.removeAll(hashSet, true);
    }
}

