/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.flap;

import bibliothek.gui.DockController;
import bibliothek.gui.DockUI;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.FlapDockStation;
import bibliothek.gui.dock.action.DefaultDockActionSource;
import bibliothek.gui.dock.action.DockAction;
import bibliothek.gui.dock.action.ListeningDockAction;
import bibliothek.gui.dock.action.actions.SimpleMenuAction;
import bibliothek.gui.dock.action.actions.SimpleSelectableAction;
import bibliothek.gui.dock.event.IconManagerListener;
import bibliothek.gui.dock.util.IconManager;
import javax.swing.Icon;

public class FlapDockDirection
extends SimpleMenuAction
implements ListeningDockAction {
    private DirectedArrow north;
    private DirectedArrow south;
    private DirectedArrow east;
    private DirectedArrow west;
    private DirectedArrow center;
    private DockController controller;
    private Listener listener = new Listener();

    public FlapDockDirection(DockController dockController) {
        this.setText(DockUI.getDefaultDockUI().getString("flap.direction"));
        this.setTooltip(DockUI.getDefaultDockUI().getString("flap.direction.tooltip"));
        this.center = new DirectedArrow(null);
        this.north = new DirectedArrow(FlapDockStation.Direction.NORTH);
        this.south = new DirectedArrow(FlapDockStation.Direction.SOUTH);
        this.east = new DirectedArrow(FlapDockStation.Direction.EAST);
        this.west = new DirectedArrow(FlapDockStation.Direction.WEST);
        this.north.setText(DockUI.getDefaultDockUI().getString("flap.direction.north"));
        this.north.setTooltip(DockUI.getDefaultDockUI().getString("flap.direction.north.tooltip"));
        this.south.setText(DockUI.getDefaultDockUI().getString("flap.direction.south"));
        this.south.setTooltip(DockUI.getDefaultDockUI().getString("flap.direction.south.tooltip"));
        this.east.setText(DockUI.getDefaultDockUI().getString("flap.direction.east"));
        this.east.setTooltip(DockUI.getDefaultDockUI().getString("flap.direction.east.tooltip"));
        this.west.setText(DockUI.getDefaultDockUI().getString("flap.direction.west"));
        this.west.setTooltip(DockUI.getDefaultDockUI().getString("flap.direction.west.tooltip"));
        this.center.setText(DockUI.getDefaultDockUI().getString("flap.direction.center"));
        this.center.setTooltip(DockUI.getDefaultDockUI().getString("flap.direction.center.tooltip"));
        DefaultDockActionSource defaultDockActionSource = new DefaultDockActionSource(new DockAction[0]);
        defaultDockActionSource.add(this.center);
        defaultDockActionSource.addSeparator();
        defaultDockActionSource.add(this.north, this.south, this.east, this.west);
        this.setMenu(defaultDockActionSource);
        this.setController(dockController);
    }

    public void setController(DockController dockController) {
        if (this.controller != dockController) {
            IconManager iconManager;
            if (this.controller != null) {
                iconManager = this.controller.getIcons();
                iconManager.remove("flap.direction", this.listener);
                iconManager.remove("flap.south", this.listener);
                iconManager.remove("flap.east", this.listener);
                iconManager.remove("flap.west", this.listener);
                iconManager.remove("flap.north", this.listener);
                iconManager.remove("flap.auto", this.listener);
            }
            this.controller = dockController;
            if (dockController != null) {
                iconManager = dockController.getIcons();
                iconManager.add("flap.direction", this.listener);
                iconManager.add("flap.south", this.listener);
                iconManager.add("flap.east", this.listener);
                iconManager.add("flap.west", this.listener);
                iconManager.add("flap.north", this.listener);
                iconManager.add("flap.auto", this.listener);
                this.setIcon(iconManager.getIcon("flap.direction"));
                this.north.setIcon(iconManager.getIcon("flap.north"));
                this.south.setIcon(iconManager.getIcon("flap.south"));
                this.east.setIcon(iconManager.getIcon("flap.east"));
                this.west.setIcon(iconManager.getIcon("flap.west"));
                this.center.setIcon(iconManager.getIcon("flap.auto"));
            }
        }
    }

    private void fire() {
        this.center.fireSelectedChanged();
        this.north.fireSelectedChanged();
        this.south.fireSelectedChanged();
        this.east.fireSelectedChanged();
        this.west.fireSelectedChanged();
    }

    private FlapDockStation getStation(Dockable dockable) {
        if (dockable instanceof FlapDockStation) {
            return (FlapDockStation)dockable;
        }
        if (dockable.getDockParent() != null) {
            return this.getStation(dockable.getDockParent().asDockable());
        }
        throw new IllegalArgumentException("Dockable or parent is not a FlapDockStation");
    }

    private class DirectedArrow
    extends SimpleSelectableAction.Radio {
        private FlapDockStation.Direction direction;

        public DirectedArrow(FlapDockStation.Direction direction) {
            this.direction = direction;
        }

        public boolean isSelected(Dockable dockable) {
            FlapDockStation flapDockStation = FlapDockDirection.this.getStation(dockable);
            if (this.direction == null) {
                return flapDockStation.isAutoDirection();
            }
            return !flapDockStation.isAutoDirection() && flapDockStation.getDirection() == this.direction;
        }

        public void setSelected(Dockable dockable, boolean bl) {
            if (bl) {
                FlapDockStation flapDockStation = FlapDockDirection.this.getStation(dockable);
                if (this.direction == null) {
                    flapDockStation.setAutoDirection(true);
                } else {
                    flapDockStation.setAutoDirection(false);
                    flapDockStation.setDirection(this.direction);
                }
                FlapDockDirection.this.fire();
            }
        }

        public void fireSelectedChanged() {
            super.fireSelectedChanged();
        }
    }

    private class Listener
    implements IconManagerListener {
        private Listener() {
        }

        public void iconChanged(String string, Icon icon) {
            if (string.equals("flap.direction")) {
                FlapDockDirection.this.setIcon(icon);
            } else if (string.equals("flap.north")) {
                FlapDockDirection.this.north.setIcon(icon);
            } else if (string.equals("flap.south")) {
                FlapDockDirection.this.south.setIcon(icon);
            } else if (string.equals("flap.east")) {
                FlapDockDirection.this.east.setIcon(icon);
            } else if (string.equals("flap.west")) {
                FlapDockDirection.this.west.setIcon(icon);
            } else if (string.equals("flap.auto")) {
                FlapDockDirection.this.center.setIcon(icon);
            }
        }
    }
}

