/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.control;

import bibliothek.gui.DockController;
import bibliothek.gui.dock.DockElement;
import bibliothek.gui.dock.event.KeyboardListener;
import bibliothek.gui.dock.event.LocatedListenerList;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.List;

public abstract class KeyboardController {
    private LocatedListenerList<KeyboardListener> keyListeners = new LocatedListenerList();
    private List<KeyListener> globalListeners = new ArrayList<KeyListener>();
    private DockController controller;

    public KeyboardController(DockController dockController) {
        this.controller = dockController;
    }

    public void addGlobalListener(KeyListener keyListener) {
        if (keyListener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        this.globalListeners.add(keyListener);
    }

    public void removeGlobalListener(KeyListener keyListener) {
        this.globalListeners.remove(keyListener);
    }

    public void addListener(KeyboardListener keyboardListener) {
        if (keyboardListener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        this.keyListeners.addListener(keyboardListener);
    }

    public void removeListener(KeyboardListener keyboardListener) {
        this.keyListeners.removeListener(keyboardListener);
    }

    public DockController getController() {
        return this.controller;
    }

    public abstract void kill();

    protected void fireKeyPressed(KeyEvent keyEvent) {
        KeyListener[] keyListenerArray;
        if (!keyEvent.isConsumed() && (keyListenerArray = this.controller.searchElement(keyEvent.getComponent())) != null) {
            DockElement dockElement = keyListenerArray.getElement();
            List<KeyboardListener> list = this.keyListeners.affected(dockElement);
            for (KeyboardListener keyboardListener : list) {
                if (!keyboardListener.keyPressed(dockElement, keyEvent)) continue;
                keyEvent.consume();
                break;
            }
        }
        for (KeyListener keyListener : this.globalListeners.toArray(new KeyListener[this.globalListeners.size()])) {
            keyListener.keyPressed(keyEvent);
        }
    }

    protected void fireKeyReleased(KeyEvent keyEvent) {
        KeyListener[] keyListenerArray;
        if (!keyEvent.isConsumed() && (keyListenerArray = this.controller.searchElement(keyEvent.getComponent())) != null) {
            DockElement dockElement = keyListenerArray.getElement();
            List<KeyboardListener> list = this.keyListeners.affected(dockElement);
            for (KeyboardListener keyboardListener : list) {
                if (!keyboardListener.keyReleased(dockElement, keyEvent)) continue;
                keyEvent.consume();
                break;
            }
        }
        for (KeyListener keyListener : this.globalListeners.toArray(new KeyListener[this.globalListeners.size()])) {
            keyListener.keyReleased(keyEvent);
        }
    }

    protected void fireKeyTyped(KeyEvent keyEvent) {
        KeyListener[] keyListenerArray;
        if (!keyEvent.isConsumed() && (keyListenerArray = this.controller.searchElement(keyEvent.getComponent())) != null) {
            DockElement dockElement = keyListenerArray.getElement();
            List<KeyboardListener> list = this.keyListeners.affected(dockElement);
            for (KeyboardListener keyboardListener : list) {
                if (!keyboardListener.keyTyped(dockElement, keyEvent)) continue;
                keyEvent.consume();
                break;
            }
        }
        for (KeyListener keyListener : this.globalListeners.toArray(new KeyListener[this.globalListeners.size()])) {
            keyListener.keyTyped(keyEvent);
        }
    }
}

