/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.action;

import bibliothek.gui.dock.action.AbstractDockActionSource;
import bibliothek.gui.dock.action.DockAction;
import bibliothek.gui.dock.action.DockActionSource;
import bibliothek.gui.dock.action.LocationHint;
import bibliothek.gui.dock.event.DockActionSourceListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FilteredDockActionSource
extends AbstractDockActionSource {
    private DockActionSource source;
    private List<Boolean> actions = null;
    private Listener listener = new Listener();

    public FilteredDockActionSource(DockActionSource dockActionSource) {
        if (dockActionSource == null) {
            throw new IllegalArgumentException("source must not be null");
        }
        this.source = dockActionSource;
    }

    @Override
    public Iterator<DockAction> iterator() {
        return new Iterator<DockAction>(){
            private Iterator<DockAction> iterator;
            private DockAction next;
            {
                this.iterator = FilteredDockActionSource.this.source.iterator();
                this.advance();
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public DockAction next() {
                DockAction dockAction = this.next;
                this.advance();
                return dockAction;
            }

            private void advance() {
                while (this.iterator.hasNext()) {
                    DockAction dockAction = this.iterator.next();
                    if (!FilteredDockActionSource.this.include(dockAction)) continue;
                    this.next = dockAction;
                    return;
                }
                this.next = null;
            }

            @Override
            public void remove() {
                this.iterator.remove();
            }
        };
    }

    @Override
    public void addDockActionSourceListener(DockActionSourceListener dockActionSourceListener) {
        if (this.listeners.isEmpty()) {
            this.source.addDockActionSourceListener(this.listener);
            this.actions = new ArrayList<Boolean>();
            for (DockAction dockAction : this.source) {
                this.actions.add(this.include(dockAction));
            }
        }
        super.addDockActionSourceListener(dockActionSourceListener);
    }

    @Override
    public void removeDockActionSourceListener(DockActionSourceListener dockActionSourceListener) {
        super.removeDockActionSourceListener(dockActionSourceListener);
        if (this.listeners.isEmpty()) {
            this.source.removeDockActionSourceListener(this.listener);
            this.actions = null;
        }
    }

    @Override
    public DockAction getDockAction(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Index out of bounds: " + n);
        }
        int n2 = -1;
        if (this.actions == null) {
            for (DockAction dockAction : this.source) {
                if (!this.include(dockAction) || n != ++n2) continue;
                return dockAction;
            }
        } else {
            int n3 = this.source.getDockActionCount();
            for (int i = 0; i < n3; ++i) {
                if (!this.actions.get(i).booleanValue() || n != ++n2) continue;
                return this.source.getDockAction(i);
            }
        }
        throw new IllegalArgumentException("Index out of bounds: " + n);
    }

    @Override
    public int getDockActionCount() {
        int n = 0;
        if (this.actions == null) {
            for (DockAction dockAction : this.source) {
                if (!this.include(dockAction)) continue;
                ++n;
            }
        } else {
            int n2 = this.source.getDockActionCount();
            for (int i = 0; i < n2; ++i) {
                if (!this.actions.get(i).booleanValue()) continue;
                ++n;
            }
        }
        return n;
    }

    @Override
    public LocationHint getLocationHint() {
        return this.source.getLocationHint();
    }

    protected abstract boolean include(DockAction var1);

    private class Listener
    implements DockActionSourceListener {
        private Listener() {
        }

        public void actionsAdded(DockActionSource dockActionSource, int n, int n2) {
            int n3;
            int n4 = 0;
            for (n3 = 0; n3 < n; ++n3) {
                if (!((Boolean)FilteredDockActionSource.this.actions.get(n3)).booleanValue()) continue;
                ++n4;
            }
            n3 = 0;
            for (int i = n; i <= n2; ++i) {
                DockAction dockAction = dockActionSource.getDockAction(i);
                boolean bl = FilteredDockActionSource.this.include(dockAction);
                FilteredDockActionSource.this.actions.add(i, bl);
                if (!bl) continue;
                ++n3;
            }
            if (n3 > 0) {
                FilteredDockActionSource.this.fireAdded(n4, n4 + n3 - 1);
            }
        }

        public void actionsRemoved(DockActionSource dockActionSource, int n, int n2) {
            int n3;
            int n4 = 0;
            for (n3 = 0; n3 < n; ++n3) {
                if (!((Boolean)FilteredDockActionSource.this.actions.get(n3)).booleanValue()) continue;
                ++n4;
            }
            n3 = 0;
            for (int i = n2; i >= n; --i) {
                if (!((Boolean)FilteredDockActionSource.this.actions.remove(i)).booleanValue()) continue;
                ++n3;
            }
            if (n3 > 0) {
                FilteredDockActionSource.this.fireRemoved(n4, n4 + n3 - 1);
            }
        }
    }
}

