/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.theme.bubble;

import bibliothek.extension.gui.dock.theme.bubble.BubbleColorAnimation;
import bibliothek.extension.gui.dock.theme.bubble.RoundButtonConnectable;
import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.action.DockAction;
import bibliothek.gui.dock.themes.basic.action.BasicButtonModel;
import bibliothek.gui.dock.themes.basic.action.BasicButtonModelAdapter;
import bibliothek.gui.dock.themes.basic.action.BasicTrigger;
import bibliothek.gui.dock.themes.color.ActionColor;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.Icon;
import javax.swing.JComponent;

public class RoundButton
extends JComponent
implements RoundButtonConnectable {
    private BubbleColorAnimation animation;
    private BasicButtonModel model;
    private RoundActionColor[] colors;

    public RoundButton(BasicTrigger basicTrigger, Dockable dockable, DockAction dockAction) {
        this.setFocusable(true);
        this.animation = new BubbleColorAnimation();
        this.colors = new RoundActionColor[]{new RoundActionColor("action.button", dockable, dockAction, Color.WHITE), new RoundActionColor("action.button.enabled", dockable, dockAction, Color.LIGHT_GRAY), new RoundActionColor("action.button.selected", dockable, dockAction, Color.YELLOW), new RoundActionColor("action.button.selected.enabled", dockable, dockAction, Color.ORANGE), new RoundActionColor("action.button.mouse.enabled", dockable, dockAction, Color.RED), new RoundActionColor("action.button.mouse.selected.enabled", dockable, dockAction, new Color(128, 0, 0)), new RoundActionColor("action.button.pressed.enabled", dockable, dockAction, Color.BLUE), new RoundActionColor("action.button.pressed.selected.enabled", dockable, dockAction, Color.MAGENTA), new RoundActionColor("action.button.focus", dockable, dockAction, Color.DARK_GRAY), new RoundActionColor("action.button.enabled.focus", dockable, dockAction, Color.DARK_GRAY), new RoundActionColor("action.button.selected.focus", dockable, dockAction, Color.DARK_GRAY), new RoundActionColor("action.button.selected.enabled.focus", dockable, dockAction, Color.DARK_GRAY), new RoundActionColor("action.button.mouse.enabled.focus", dockable, dockAction, Color.DARK_GRAY), new RoundActionColor("action.button.mouse.selected.enabled.focus", dockable, dockAction, Color.DARK_GRAY), new RoundActionColor("action.button.pressed.enabled.focus", dockable, dockAction, Color.DARK_GRAY), new RoundActionColor("action.button.pressed.selected.enabled.focus", dockable, dockAction, Color.DARK_GRAY)};
        this.model = new BasicButtonModel(this, basicTrigger){

            public void changed() {
                RoundButton.this.updateColors();
                RoundButton.this.repaint();
            }
        };
        this.model.addListener(new BasicButtonModelAdapter(){

            public void mousePressed(BasicButtonModel basicButtonModel, boolean bl) {
                if (bl) {
                    RoundButton.this.requestFocusInWindow();
                }
            }
        });
        this.updateColors();
        this.animation.addTask(new Runnable(){

            public void run() {
                RoundButton.this.repaint();
            }
        });
        this.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
                RoundButton.this.repaint();
            }

            public void focusLost(FocusEvent focusEvent) {
                RoundButton.this.repaint();
            }
        });
    }

    public void setController(DockController dockController) {
        for (RoundActionColor roundActionColor : this.colors) {
            roundActionColor.connect(dockController);
        }
        this.animation.kick();
    }

    public BasicButtonModel getModel() {
        return this.model;
    }

    public boolean contains(int n, int n2) {
        double d;
        double d2;
        double d3;
        double d4;
        if (!super.contains(n, n2)) {
            return false;
        }
        double d5 = this.getWidth();
        if (d5 > (d4 = (double)this.getHeight())) {
            d3 = d4 / d5;
            d2 = n;
            d = d3 * (double)n2;
            d4 = d5;
        } else {
            d3 = d5 / d4;
            d2 = d3 * (double)n;
            d = n2;
            d5 = d4;
        }
        d3 = (d2 -= d5 / 2.0) * d2 + (d -= d4 / 2.0) * d;
        return d3 <= d5 * d5 / 4.0;
    }

    public Dimension getPreferredSize() {
        Dimension dimension = this.model.getMaxIconSize();
        dimension.width = Math.max(dimension.width, 10);
        dimension.height = Math.max(dimension.height, 10);
        return new Dimension((int)((double)dimension.width * 1.5), (int)((double)dimension.height * 1.5));
    }

    protected void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setColor(this.animation.getColor("button"));
        graphics2D.fillOval(0, 0, this.getWidth(), this.getHeight());
        Icon icon = this.model.getPaintIcon();
        if (icon != null) {
            icon.paintIcon(this, graphics, (this.getWidth() - icon.getIconWidth()) / 2, (this.getHeight() - icon.getIconHeight()) / 2);
        }
        if (this.hasFocus() && this.isFocusable() && this.isEnabled()) {
            Stroke stroke = graphics2D.getStroke();
            graphics2D.setStroke(new BasicStroke(3.0f));
            graphics2D.setColor(this.animation.getColor("focus"));
            graphics2D.drawOval(1, 1, this.getWidth() - 3, this.getHeight() - 3);
            graphics2D.setStroke(stroke);
        }
        graphics2D.dispose();
    }

    private void updateColors() {
        String string = "";
        boolean bl = this.model.isMousePressed();
        boolean bl2 = this.model.isMouseInside();
        boolean bl3 = this.model.isSelected();
        boolean bl4 = this.model.isEnabled();
        if (bl4 && bl) {
            string = ".pressed";
        }
        if (bl4 && bl2 && !bl) {
            string = ".mouse";
        }
        if (bl3) {
            string = string + ".selected";
        }
        if (bl4) {
            string = string + ".enabled";
        }
        String string2 = "action.button" + string;
        for (RoundActionColor roundActionColor : this.colors) {
            if (!string2.equals(roundActionColor.getId())) continue;
            this.animation.putColor("button", (Color)roundActionColor.value());
            break;
        }
        string2 = string2 + ".focus";
        for (RoundActionColor roundActionColor : this.colors) {
            if (!string2.equals(roundActionColor.getId())) continue;
            this.animation.putColor("focus", (Color)roundActionColor.value());
            break;
        }
    }

    private class RoundActionColor
    extends ActionColor {
        public RoundActionColor(String string, Dockable dockable, DockAction dockAction, Color color) {
            super(string, dockable, dockAction, color);
        }

        protected void changed(Color color, Color color2) {
            RoundButton.this.updateColors();
        }
    }
}

