/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.common.CControl;
import bibliothek.gui.dock.common.CGrid;
import bibliothek.gui.dock.common.CGridArea;
import bibliothek.gui.dock.common.CLocation;
import bibliothek.gui.dock.common.MultipleCDockable;
import bibliothek.gui.dock.common.SingleCDockable;
import bibliothek.gui.dock.common.intern.CControlAccess;
import bibliothek.gui.dock.common.intern.CommonDockable;
import bibliothek.gui.dock.common.location.CWorkingAreaLocation;
import bibliothek.gui.dock.station.split.SplitDockTree;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CWorkingArea
extends CGridArea {
    public CWorkingArea(CControl cControl, String string) {
        super(cControl, string);
        this.setMaximizingArea(false);
    }

    @Override
    public boolean isWorkingArea() {
        return true;
    }

    @Override
    public CLocation getStationLocation() {
        return new CWorkingAreaLocation(this);
    }

    @Override
    public void deploy(CGrid cGrid) {
        SplitDockTree splitDockTree = cGrid.toTree();
        for (Dockable dockable : splitDockTree.getDockables()) {
            if (!(dockable instanceof CommonDockable)) continue;
            CommonDockable commonDockable = (CommonDockable)dockable;
            commonDockable.getDockable().setWorkingArea(this);
        }
        this.getStation().dropTree(splitDockTree);
    }

    public <F extends SingleCDockable> F add(F f) {
        f.setWorkingArea(this);
        CControlAccess cControlAccess = this.control();
        if (cControlAccess != null) {
            cControlAccess.getOwner().add(f);
        }
        return f;
    }

    public <F extends MultipleCDockable> F add(F f) {
        f.setWorkingArea(this);
        CControlAccess cControlAccess = this.control();
        if (cControlAccess != null) {
            cControlAccess.getOwner().add(f);
        }
        return f;
    }

    @Deprecated
    public void setSuppressTitle(boolean bl) {
        this.setTitleShown(!bl);
    }

    @Deprecated
    public boolean isSuppressTitle() {
        return !this.isTitleShown();
    }
}

