/*
 * Decompiled with CFR 0.152.
 */
package at.ac.ait.speedr.table.model.twodim;

import at.ac.ait.speedr.table.RColumnIndexModel;
import javax.swing.table.AbstractTableModel;
import org.rosuda.REngine.REXPGenericVector;
import org.rosuda.REngine.REXPMismatchException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RDataFrameTableModel
extends AbstractTableModel
implements RColumnIndexModel {
    private REXPGenericVector data;
    private String[] rownames;
    private String[] colnames;

    public RDataFrameTableModel(REXPGenericVector data) throws REXPMismatchException {
        this.data = data;
        this.rownames = data.getAttribute("row.names").asStrings();
        this.colnames = data.getAttribute("names").asStrings();
    }

    @Override
    public int getRowCount() {
        return this.rownames.length;
    }

    @Override
    public int getColumnCount() {
        return this.colnames.length + 1;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (columnIndex == 0) {
            return String.class;
        }
        if (this.data.asList().at(--columnIndex).isNumeric()) {
            return Double.class;
        }
        if (this.data.asList().at(columnIndex).isString()) {
            return String.class;
        }
        if (this.data.asList().at(columnIndex).isFactor()) {
            return String.class;
        }
        return super.getColumnClass(columnIndex);
    }

    @Override
    public String getColumnName(int column) {
        if (column == 0) {
            return "row.names";
        }
        return this.colnames[column - 1];
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            return this.rownames[rowIndex];
        }
        --columnIndex;
        try {
            if (this.data.asList().at(columnIndex).isNumeric()) {
                return this.data.asList().at(columnIndex).asDoubles()[rowIndex];
            }
            if (this.data.asList().at(columnIndex).isString()) {
                return this.data.asList().at(columnIndex).asStrings()[rowIndex];
            }
            if (this.data.asList().at(columnIndex).isFactor()) {
                return this.data.asList().at(columnIndex).asFactor().at(rowIndex);
            }
            return "Error: null";
        }
        catch (REXPMismatchException ex) {
            ex.printStackTrace();
            return "Error: exception";
        }
    }

    @Override
    public String getColumnIndexCode(int columnIndex) {
        return "[[\"" + this.getColumnName(columnIndex) + "\"]]";
    }

    @Override
    public String getRownameIndexCode(String var) {
        return "rownames(" + var + ")";
    }
}

