% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transform_spectra.R
\name{resample}
\alias{resample}
\alias{resample.spectra}
\title{Resample spectra}
\usage{
resample(x, new_bands, ...)

\method{resample}{spectra}(x, new_bands, ...)
}
\arguments{
\item{x}{spectra object. bands must be strictly increasing}

\item{new_bands}{numeric vector of bands to sample from spectra}

\item{...}{additional parameters passed to the \code{smooth.spline} function.}
}
\value{
spectra object with resampled spectra
}
\description{
\code{resample} returns spectra resampled to new bands using spline smoothing.
Possible to increase or decrease the spectral resolution.
}
\details{
\code{resample} doesn't predict values for bands outside of the original range.
}
\section{Methods (by class)}{
\itemize{
\item \code{spectra}: Resample spectra
}}

\examples{
library(spectrolab)
spec = as_spectra(spec_matrix_example, name_idx = 1)
spec = resample(spec, new_bands = seq(400, 2400, 0.5), parallel = FALSE)
}
\author{
Jose Eduardo Meireles
}
