% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/waterfall.R
\name{waterfall}
\alias{waterfall}
\title{Estimate the local frequencies}
\usage{
waterfall(y = stop("y value is missing"), x = NULL, nf = 3,
  width = 10)
}
\arguments{
\item{y}{numeric real valued data vector}

\item{x}{numeric real valued spatial vector. (time or space)}

\item{nf}{steepness of the bandpass filter, degree of the polynomial.}

\item{width}{normalized (to \eqn{df}) maximum width of the bandpass.}
}
\value{
a special \code{fft}-object is returned. It has mode "waterfall" and
        \code{x} and \code{fx} present, so it is only plotable.
}
\description{
A \code{waterfall}-diagramm displays the local frequency in dependence of
or spatial vector. One can then locate an event in time or space.
}
\details{
Each frequency is evaluated by calculating the amplitude demodulation, which
is equivalent to the envelope function of the bandpass filtered signal.
The frequency of interest defines automatically the center frequency of the
applied bandpass with the bandwidth \eqn{BW}:
\deqn{BW = f0 / 4, BW < 4df -> BW = 4df, BW > width * df -> BW = width * df}
The minimal frequency is \eqn{df} and \eqn{f0} denotes the center
frequency of the bandpass.
With increasing frequency the bandwidth becomes wider, which lead to a variable
resolution in space and frequency. This is comparable to the wavelet
(or Gabor) transform,
which scales the wavelet (window) according to the frequency.
However, the necessary bandwidth is changed by frequency to take the
uncertainty principle into account. Slow oscillating events are measured precisely
in frequency and fast changing processes can be determined more exact in space.
This means for a signal with steady
increasing frequency the \code{waterfall} function will produce a diagonally
stripe. See the examples below.
}
\examples{
## noisy signal with amplitude modulation
x <- seq(0,1, length.out=1000)
# original data
# extended example from envelope function
y <- 2*(abs(x-0.5))*sin(10*2*pi*x) + ifelse(x > 0.5,sin(10*(1+2*(x - 0.5))*2*pi*x),0)
ye <- base::Re(envelope(y))

par(mfrow=c(2,1),mar=c(1,3.5,3,3),mgp=c(2.5,1,0))
# plot results
plot(x,y,type="l",lwd=1,col="darkgrey",lty=2,ylab="y",main="Original Data",xaxt="n",xlab="")
lines(x,ye)
legend("bottomright",c("modulated","envelope"),col=c("grey","black"),lty=c(2,1))

par(mar=c(3.5,3.5,2,0))
wf <- waterfall(y,x,nf = 3)
plot(wf,ylim=c(0,40),main="Waterfall")


## uncertainty principle
#
# take a look at the side effects at [0,30] and [1,0]
#
# with a large steepness e.g. n=50 you will gain
# artefacts.
#
x <- seq(0,1, length.out=500)
y <- sin(100*x*x)

par(mfrow=c(2,1),mar=c(1,3.5,3,3),mgp=c(2.5,1,0))
# plot results
plot(x,y,type="l",lwd=1,col="darkgrey",lty=2,ylab="y",main="Original Data",xaxt="n",xlab="")

par(mar=c(3.5,3.5,2,0))
wf <- waterfall(y,x)
rasterImage2(x = wf$x, y= wf$fx,z=wf$A,ylim=c(0,40),main="Waterfall")

}
