% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SearchImages.R
\name{SearchImages}
\alias{SearchImages}
\title{Search Spectator database for available images}
\source{
\url{https://api.spectator.earth/#searching-for-images}
}
\usage{
SearchImages(
  aoi,
  satellites = NULL,
  date_from = NULL,
  date_to = NULL,
  footprint = FALSE,
  api_key = Sys.getenv("spectator_earth_api_key")
)
}
\arguments{
\item{aoi}{'\code{sf}' (or '\code{Spatial*}') object defining the area of interest.
Can be of any geometry as only the bounding box is used.}

\item{satellites}{character vector, if specified only the listed satellites will be retrieved,
if \code{NULL} (default value) the acquisition plans for all possible satellites will be retrieved.
For simplicity, the satellites names can be abbreviated to
"S-1A", "S-1B", "S-2A", "S-2B", "L-8" or "S1A", "S1B", "S2A", "S2B", "L8". Default: NULL}

\item{date_from}{date or character convertible to date by \code{as.Date}, indicating the earliest image date. Default: NULL}

\item{date_to}{date or character convertible to date by \code{as.Date}, indicating the latest image date. Default: NULL}

\item{footprint}{logical indicating if the polygons describing the image tiles should be returned. Default: FALSE}

\item{api_key}{character containing your API key. Default: \code{Sys.getenv("spectator_earth_api_key")}}
}
\value{
Either a data frame (if '\code{footprint}' is '\code{FALSE}') or
an object of class '\code{sf}' with '\code{POLYGON}' geometry type (if '\code{footprint}' is '\code{TRUE}').
}
\description{
Returns the list of available images for an area of interest, specified time interval and selected satellites.
}
\details{
The data frame contains some useful attributes: \code{id} which enables to download images
using the functions \code{\link[spectator]{GetImageryFilesList}} or
\code{\link[spectator]{GetHighResolutionImage}},
\code{cloud_cover_percentage} (for the whole image tile), \code{satellite} (name),
\code{begin_position_date} and \code{end_position_date} indicating when the image was taken.
}
\examples{
if(interactive()){ 
 library(sf)
 my_key <- Sys.getenv("spectator_earth_api_key")
 # get the New York City Central Park shape as area of interest
 dsn <- system.file("extdata", "centralpark.geojson", package = "spectator")
 boundary <- sf::read_sf(dsn, as_tibble = FALSE)
 # search for May 2021 Sentinel 2 images 
 catalog <- SearchImages(aoi = boundary, satellites = "S2", 
     date_from = "2021-05-01", date_to = "2021-05-30", 
     footprint = FALSE, api_key = my_key)
 }
}
