% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findRef.R
\name{findRef}
\alias{findRef}
\title{Reference finding}
\usage{
findRef(peakList)
}
\arguments{
\item{peakList}{The peak lists of the spectra.}
}
\value{
list of 2: refInd (The index of the reference spectrum found by the algorithm) and orderSpec (A sorted array of the spectra by their goodness values)
}
\description{
This function is to heuristically detect a reference spectrum.
}
\examples{
res=makeSimulatedData();
X=res$data;
groupLabel=res$label;
peakList <- detectSpecPeaks(X,
                            nDivRange = c(128),
                            scales = seq(1, 16, 2),
                            baselineThresh = 50000,
                            SNR.Th = -1,
                            verbose=FALSE
);
cat("\n Find the spectrum reference...")
resFindRef<- findRef(peakList);
refInd <- resFindRef$refInd;
cat("\n Order of spectrum for reference  \n");
for (i in seq_along(resFindRef$orderSpec))
    cat(paste(i, ":",resFindRef$orderSpec[i],sep=""), " ");
cat("\n The reference is: ", refInd);

}
\references{
Vu TN, Valkenborg D, Smets K, Verwaest KA, Dommisse R, Lemi\`{e}re F, Verschoren A, Goethals B, Laukens K. (2011) An integrated workflow for robust alignment and simplified quantitative analysis of NMR spectrometry data. BMC Bioinformatics. 2011 Oct 20;12:405.
}
\author{
Trung Nghia Vu
}
