% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createNullSampling.R
\name{createNullSampling}
\alias{createNullSampling}
\title{Building a null hypothesis data}
\usage{
createNullSampling(X, groupLabel, N = 100, verbose = TRUE)
}
\arguments{
\item{X}{The spectral dataset in the matrix format in which each row contains a single sample}

\item{groupLabel}{Group label of samples in the dataset}

\item{N}{The number of iteration for creating null sample distribution}

\item{verbose}{A boolean value to allow print out process information}
}
\value{
A matrix with N rows containing the null distribution.
}
\description{
Create a null sampling data (N times) and write them to a file
}
\examples{
res=makeSimulatedData();
X=res$data;
groupLabel=res$label;
peakList <- detectSpecPeaks(X,
                            nDivRange = c(128),
                            scales = seq(1, 16, 2),
                            baselineThresh = 50000,
                            SNR.Th = -1,
                            verbose=FALSE
);
resFindRef<- findRef(peakList);
refInd <- resFindRef$refInd;
maxShift = 50;
Y <- dohCluster(X,
                peakList = peakList,
                refInd = refInd,
                maxShift  = maxShift,
                acceptLostPeak = TRUE, verbose=FALSE);
# find the BW-statistic
BW = BWR(Y, groupLabel);
H0 = createNullSampling(Y, groupLabel, N = 100,verbose=FALSE)

}
\author{
Trung Nghia Vu
}
