% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findFirstStudyRegionPoint.R
\name{findFirstStudyRegionPoint}
\alias{findFirstStudyRegionPoint}
\title{Get a randomly chosen Halton point from within the study area and the associated seeds.}
\usage{
findFirstStudyRegionPoint(shapefile, bb, seeds, verbose = FALSE)
}
\arguments{
\item{shapefile}{Shape file as a polygon (sp or sf) of the study area(s).}

\item{bb}{Bounding box which defines the Master Sample. A bounding box must be
supplied.}

\item{seeds}{A vector of 2 seeds, u1 and u2. If not specified, the default is NULL and will
be defined randomly using function \code{generateUVector}.}

\item{verbose}{Boolean if you want to see any output printed to screen. Helpful if taking a
long time. Default is FALSE i.e. no informational messages are displayed.}
}
\value{
A list containing three variables:

\itemize{
\item \code{seeds} The u1 and u2 seeds used to generate the first point.
\item \code{k} The index of the first point in the initial sample.
}
}
\description{
This function repeatedly calls function spbal::getBASSample
to generate the Halton frame sample. This function selects the first point at random from those
points in the study area. This point and the seeds used to generate the sample are returned to
the caller.
}
\author{
This function was written by Phil Davies.
}
\keyword{internal}
