% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dyads.R
\name{dyad_id}
\alias{dyad_id}
\title{Dyad ID}
\usage{
dyad_id(DT = NULL, id1 = NULL, id2 = NULL)
}
\arguments{
\item{DT}{input data.table with columns id1 and id2, as generated by
\code{edge_dist} or \code{edge_nn}}

\item{id1}{ID1 column name generated by \code{edge_dist} or \code{edge_nn}}

\item{id2}{ID2 column name generated by \code{edge_dist} or \code{edge_nn}}
}
\value{
\code{dyad_id} returns the input \code{data.table} with appended "dyadID"
column
}
\description{
Generate a dyad ID for edge list generated by \code{\link{edge_nn}} or
\code{\link{edge_dist}}.
}
\details{
An undirected edge identifier between, for example individuals A and B will
be A-B (and reverse B and A will be A-B). Internally sorts and pastes id
columns.

More details in the edge and dyad vignette (in progress).
}
\examples{
# Load data.table
library(data.table)

# Read example data
DT <- fread(system.file("extdata", "DT.csv", package = "spatsoc"))

# Cast the character column to POSIXct
DT[, datetime := as.POSIXct(datetime, tz = 'UTC')]

# Temporal grouping
group_times(DT, datetime = 'datetime', threshold = '20 minutes')

# Edge list generation
edges <- edge_dist(
    DT,
    threshold = 100,
    id = 'ID',
    coords = c('X', 'Y'),
    timegroup = 'timegroup',
    returnDist = TRUE,
    fillNA = TRUE
  )

# Generate dyad IDs
dyad_id(edges, 'ID1', 'ID2')
}
