% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/convK.R
\name{applyFilter}
\alias{applyFilter}
\title{Function for applying convolution kernel to a matrix or array}
\usage{
applyFilter(x, kernel)
}
\arguments{
\item{x}{An object of class \code{matrix} or \code{array}}

\item{kernel}{A \code{matrix} containing the values chosen as convolution kernel}
}
\value{
An object with the same size of \code{x} containing data processed by convolution kernel
}
\description{
This function applies the a convolution kernel based filter to a \code{matrix} or \code{array} object type.
}
\details{
The application of a convolution kernel over a 2D matrix dataset allows to apply functions as smoothing or edge detection.
The aim of this function is to filter 2D matrices in order to help signal finding across (images-derived) data. It is also possible to
filter 3D arrays considering them as slices of a series of images to be processed. Higher dimensions arrays are not allowed.
The \code{kernel} parameter is a simple \bold{square matrix} with an odd number of rows/columns, that can be pre-calculated by using
the function \code{\link{convKernel}}. Not square matrices or matrices with even number of rows/columns will exit an error.
}
\examples{
## Not run:
M <- array(runif(1000000), dim = c(100,100,100))
# smooth the array M
Mfil <- applyFilter(x = M, kernel = convKernel(sigma = 1.4, k = 'gaussian'))
image(M[,,50], col = grey(1:1000/1000))
image(Mfil[,,50], col = grey(1:1000/1000))

# now combining two filters in cascade
Mfil <- applyFilter(x = applyFilter(x = M, kernel = convKernel(k = 'sobel')),
                    kernel = convKernel(sigma = 1.4, k = 'gaussian'))
image(Mfil[,,50], col = grey(1:1000/1000))
## End(**Not run**)
}

