% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/erase.points.R
\name{erase.point}
\alias{erase.point}
\title{Erase points}
\usage{
erase.point(y, x, inside = TRUE)
}
\arguments{
\item{y}{A SpatialPoints or SpatialPointsDataFrame}

\item{x}{A SpatialPolygons or SpatialPolygonsDataFrame}

\item{inside}{(TRUE/FALSE) Remove points inside polygon, else outside polygon}
}
\value{
A SpatialPoints or SpatialPointsDataFrame
}
\description{
Removes points intersecting a polygon feature class
}
\note{
Used to erase points that intersect polygon(s). If inside=FALSE then
the function results in an intersection operation where points that
intersect the polygon are retained. This function effectively duplicates
the ESRI ArcGIS Erase Point tool.
}
\examples{
library(sp)
library(raster)
library(rgeos)
  data(meuse)
  coordinates(meuse) = ~x+y

# Create systematic sample and polygons
s <- spsample(x=as(extent(meuse), "SpatialPolygons"), n=1000,
              type="regular")
b <- rgeos::gBuffer(s[sample(1:length(s),5),],
                    byid = FALSE, width = 300)

# Erase points based on polygons
s.erase <- erase.point(s, b)
 
 opar <- par(no.readonly=TRUE)
 par(mfrow=c(2,2))
   plot(s, pch=20, main="original data")
   plot(b, main="erased data")
     points(s.erase, pch=20)
   plot(b, main="erased data using inside=FALSE")
     points(erase.point(s, b, inside=FALSE), pch=20)
 par(opar)

}
\author{
Jeffrey S. Evans    <jeffrey_evans<at>tnc.org>
}
