% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alphastats.R
\name{alphastats}
\alias{alphastats}
\title{Geometric Spatial Point Pattern Analysis}
\usage{
alphastats(x, y, scale = FALSE, nalphas = 100, envelope = FALSE, mc_cores = 1)
}
\arguments{
\item{x}{numeric matrix or data.frame of covariables.}

\item{y}{numeric vector of responses in a model.}

\item{scale}{boolean to make the estimations with scaled variables. Default
\code{FALSE}.}

\item{nalphas}{a single number for the number of alphas generated between the
minimum and maximum edge distance on the Delanauy triangulation.}

\item{envelope}{boolean to determine if the Monte-Carlo is estimated. Default
\code{FALSE}.}

\item{mc_cores}{an integer to determine how many parallel process should be
run. Default \code{mc_core=1}.}
}
\value{
A list of class \code{spatgeom} with  the following elements:

\describe{
\item{\strong{call}}{The function call.}

\item{\strong{x}}{\code{x} input.}

\item{\strong{y}}{\code{y} output.}

\item{\strong{results}}{A list of size \code{ncol(x)} corresponding to each
column of \code{x}. Each element of the list has:
\describe{

\item{\strong{triangles}}{a data frame of class \code{sfc} (see
\code{\link[sf:sf]{sf::st_sf()}})with columns \code{geometry}, \code{segments},
\code{max_length} and \code{alpha}. The data.frame contains the whole
Delanauy triangulation for the corresponding column of \code{x} and \code{y}.
The \code{segments} column are the segments of each individual triangle and
\code{max_length} is the maximum length of them.}

\item{\strong{data_frame_triangles}}{a data frame with columns \code{alpha}
and \code{geom_corr}. The \code{alpha} column is a numeric vector of size
\code{nalphas} from the minimum to the maximum distance between points
estimated in the data. The \code{geom_corr} column is the value \code{1 -
 (alpha shape Area)/(containing box Area).}}

\item{\strong{intensity}}{the intensity estimated for the corresponding
column of \code{x} and \code{y}.}

\item{\strong{mean_n}}{the mean number of points in the point process.}

\item{\strong{envelope_data}}{a data frame in tidy format with 40 runs of a
CSR process, if \code{envelope=TRUE}, The CSR is created by generating
\emph{n} uniform points in the plane, where \emph{n} is drawn from Poisson
distribution with parameter \code{mean_n}.

}}}}
}
\description{
Function to estimate the geometric correlation between
variables.
}
\examples{
n <- 30
a <- -1
b <- 1
theta <- runif(n, 0, 2 * pi)
r <- (sqrt(runif(n))) * (0.5) + 0.5
X1 <- r * cos(theta)
X2 <- runif(n, a, b)
Y <- data.frame(Y = r * sin(theta))
X <- data.frame(X1, X2)

estimation <- alphastats(y = Y, x = X)
}
\references{
Hernández, A.J., Solís, M. Geometric goodness of fit measure to detect
patterns in data point clouds. Comput Stat (2022).
https://doi.org/10.1007/s00180-022-01244-1
}
