% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/he10.R, R/he10coordinates.R,
%   R/he10demography.R, R/he10measles.R, R/he10mle.R
\name{he10}
\alias{he10}
\alias{he10coordinates}
\alias{he10demography}
\alias{he10measles}
\alias{he10mle}
\title{Measles in UK: spatPomp generator with shared or unit-specific parameters}
\usage{
he10(
  U = 6,
  dt = 2/365,
  Tmax = 1964,
  expandedParNames = c("alpha", "iota", "R0", "cohort", "amplitude", "gamma", "sigma",
    "sigmaSE", "rho", "psi", "g", "S_0", "E_0", "I_0"),
  basic_params = c(alpha = 1, iota = 0, R0 = 30, cohort = 0, amplitude = 0.5, gamma = 52,
    sigma = 52, mu = 0.02, sigmaSE = 0.15, rho = 0.5, psi = 0.15, g = 400, S_0 = 0.032,
    E_0 = 5e-05, I_0 = 4e-05),
  towns_selected = NULL
)
}
\arguments{
\item{U}{A length-one numeric signifying the number of cities to be
represented in the spatPomp object. Default U=20 gives all the towns
studied by He et al., the 10 largest and 10 selected smaller towns.}

\item{dt}{a numeric (in unit of years) that is used as the Euler time-increment for simulating measles data.}

\item{Tmax}{Upper time for the window used to construct the object. The lower time is fixed at 1950.0. The default value matches He et al (2010).}

\item{expandedParNames}{specifies the names of parameters which take unit-specific values. Remaining parameters take a single, shared value for all units.}

\item{basic_params}{A candidate parameter vector in the basic format, i.e., no unit-specific parameters or unit-related name extensions.}

\item{towns_selected}{A numeric vector of towns to be modeled. Defaults 
to 1:U, with cities ranked by decreasing population and 1 being London.}
}
\value{
An object of class \sQuote{spatPomp} representing a \code{U}-dimensional spatially coupled measles POMP model.

a \sQuote{data.frame} of longitude and lattitude for each town.

a \sQuote{data.frame} of with variables town, year, pop and births.

a \sQuote{data.frame} of reported measles cases for 20 towns,
analyzed by He et al (2010).

a \sQuote{data.frame} containing the estimated parameters.
}
\description{
Generate a spatPomp object for measles adding spatial coupling to
The model and data from He et al. (2010) with gravity transport as
in Park and Ionides (2020). Other transport models may be added in future.
The data in the object matches He et al. (2010). The model matches
that analysis in the specific case where there is no coupling and all
parameters are unit-specific.

Longitude and lattitude for the 20 towns in England and Wales studied by
He et al (2010).

Population and birth information for some towns in England and Wales
during the measles pre-vaccine era.

Measles case data from various cities and towns in England and Wales during the pre-vaccine era.

Maximum likelihood estimate for fitting a susceptible-exposed-infected-
recovered model to the measles case report data analyzed by He et al (2010).
The values are similar, but not identical, to those reported by He et al.
}
\details{
The code for this spatPomp has duplication with measles(), but in future
the two models may diverge. The measles() spatPomp is a simplified
situation useful for testing some methods. However, measles() does not
permit unit-specific parameters, which he10() allows. Also, 
the structure of this spatPomp is compatible with the spatiotemporal 
iterated filtering algorithm ibpf(). This requires shared parameters to
be represented with a value for each unit, which should be the same for each
unit in a valid model instance but may vary between units while optimizing.

Data are annual statistics for the 20 towns analyzed by He et al (2010).

Data are weekly case counts for the 20 towns analyzed by He et al (2010).
}
\note{
This function goes through a typical workflow of constructing
a typical spatPomp object (1-4 below). This allows the user to have a
file that replicates the exercise of model building as well as function
that creates a typical nonlinear model in epidemiology in case they want
to test a new inference methodology. We purposely do not modularize this
function because it is not an operational piece of the package and is
instead useful as an example.\cr
1. Getting a measurements data.frame with columns for times,
   spatial units and measurements.\cr
2. Getting a covariates data.frame with columns for times,
   spatial units and covariate data.\cr
3. Constructing model components (latent state initializer,
   latent state transition simulator and measurement model). Depending
   on the methods used, the user may have to supply a vectorfield to
   be integrated that represents the deterministic skeleton of the latent
   process.\cr
4. Bringing all the data and model components together to form a
   spatPomp object via a call to spatPomp().
}
\examples{
# Complete examples are provided in the package tests
\dontrun{
m <- he10(U = 5)
# See all the model specifications of the object
spy(m)
}
}
\references{
\he2010

\ionides2022

\he2010

\he2010

\he2010

\he2010
}
\seealso{
Other spatPomp examples: 
\code{\link{bm}()},
\code{\link{lorenz}()},
\code{\link{measles}()}

Other datasets: 
\code{\link{city_data_UK}},
\code{\link{measlesUK}}

Other datasets: 
\code{\link{city_data_UK}},
\code{\link{measlesUK}}

Other datasets: 
\code{\link{city_data_UK}},
\code{\link{measlesUK}}

Other datasets: 
\code{\link{city_data_UK}},
\code{\link{measlesUK}}
}
\author{
Edward L. Ionides
}
\concept{datasets}
\concept{spatPomp examples}
