% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lhc_analysis.R
\name{lhc_process_sample_run_subsets}
\alias{lhc_process_sample_run_subsets}
\title{Summarises results of runs for parameter sets generated by a latin-hypercube}
\usage{
lhc_process_sample_run_subsets(FILEPATH, SPARTAN_PARAMETER_FILE, PARAMETERS,
  NUMSAMPLES, NUMRUNSPERSAMPLE, MEASURES, RESULTFILENAME, ALTFILENAME,
  OUTPUTCOLSTART, OUTPUTCOLEND, LHC_ALL_SIM_RESULTS_FILE, TIMEPOINTS = NULL,
  TIMEPOINTSCALE = NULL, check_done = FALSE)
}
\arguments{
\item{FILEPATH}{Directory where the simulation runs of single CSV file can
be found}

\item{SPARTAN_PARAMETER_FILE}{Location of the file output by the
latin-hypercube sampling method. Note if providing a single CSV file
with parameter/response pairings, you do not need to provide this file,
and can thus enter this parameter as NULL.}

\item{PARAMETERS}{Array containing the names of the parameters of which
parameter samples will be generated}

\item{NUMSAMPLES}{The number of parameter subsets that were generated in the
LHC design. Only required if analysing results provided within Folder
structure setup.}

\item{NUMRUNSPERSAMPLE}{The number of runs performed for each parameter
subset. This figure is generated through Aleatory Analysis. Only required
if analysing results provided within Folder structure setup.}

\item{MEASURES}{Array containing the names of the output measures which are
used to analyse the simulation}

\item{RESULTFILENAME}{Name of the simulation results file. In the current
version, XML and CSV files can be processed. If performing this analysis
over multiple timepoints, it is assumed that the timepoint follows the
file name, e.g. trackedCells_Close_12.csv.}

\item{ALTFILENAME}{In some cases, it may be relevant to read from
a further results file if the initial file contains no results. This
filename is set here. In the current version, XML and CSV files can be
processed.}

\item{OUTPUTCOLSTART}{Column number in the simulation results file where
output begins - saves (a) reading in unnecessary data, and (b) errors where
the first column is a label, and therefore could contain duplicates.}

\item{OUTPUTCOLEND}{Column number in the simulation results file where the
last output measure is.}

\item{LHC_ALL_SIM_RESULTS_FILE}{Name to be given to the CSV file that
summarises all simulation runs for all parameter sets}

\item{TIMEPOINTS}{Implemented so this method can be used when analysing
multiple simulation timepoints. If only analysing one timepoint, this
should be set to NULL. If not, this should be an array of timepoints,
e.g. c(12,36,48,60)}

\item{TIMEPOINTSCALE}{Implemented so this method can be used when analysing
multiple simulation timepoints. Sets the scale of the timepoints being
analysed, e.g. "Hours"}

\item{check_done}{If multiple timepoints, whether the input has been checked}
}
\description{
Only to be applied for simulations that are stochastic, and responses are
supplied in the folder structure detailed in the R Journal paper, useful for
cases where the simulation is agent-based. Takes each parameter value set
generated by the hypercube in turn, and analyses the replicate simulation
results for that set. Produces a CSV file containing the parameters of the
run and the median of each simulation response for each run. In cases where,
for example, 300 runs have been performed for a parameter set, this file
will contain 300 rows for that set, each accompanied by the median of each
simulation response for that run. This file will be named as specified by
parameter LHC_ALL_SIM_RESULTS_FILE. This method can be performed for a number
of simulation timepoints, producing CSV files for each timepoint taken.
}
