lhc_generateLHCSummary <-
function(FILEPATH,PARAMETERS,MEASURES,LHC_ALL_SIM_RESULTS_FILE,LHCSUMMARYFILENAME,SPARTAN_PARAMETER_FILE=NULL,TIMEPOINTS=NULL,TIMEPOINTSCALE=NULL)
{
	# SPARTAN 2.0 - READS THIS INFORMATION FROM A SINGLE FILE, NOT ONE PER PARAMETER SET AS IN PREVIOUS VERSIONS
	# THEN PRODUCES A SUMMARY FILE WITH THE PARAMETERS USED AND THE MEDIAN OF EACH MEASURE OVER THE NUMBER OF REPLICATE RUNS
	
	if(is.null(TIMEPOINTS))
	{
		if(file.exists(FILEPATH))
		{
			# LHCSUMMARYFILENAME IS LHCSummary.csv for 1 timepoint
			# READ IN THE LHC DESIGN TABLE - NEED TO REFER TO THIS LATER AS PARAMETERS ARE LISTED WITH THE MEDIAN RESULT SET
			print("Generating LHC result summary file from median simulation results (lhc_generateLHCSummary)")

			# SUMMARY TABLE WILL STORE THE PARAMETERS USED IN THE RUN SET, AND THE MEDIAN OUTPUT MEASURES, FOR EACH SET	
			SUMMARYTABLE<-NULL

			# READ IN THE RESULT FILE - EITHER PROVIDED OR CONSTRUCTED BY THE FIRST LHC METHOD IN SPARTAN
			LHC_ALL_SIM_RESULTS<-read.csv(paste(FILEPATH,"/",LHC_ALL_SIM_RESULTS_FILE,sep=""),header=TRUE)
	
			# NOW WE ARE PROCESSING A FILE WITH MULTIPLE RUNS OF THE SAME PARAMETER SET. TO SAVE IMPORTING THE PARAMETER FILE
			# (AS THIS MAY NOT ALWAYS BE AVAILABLE), THIS READS THE PARAMETERS IN. THUS WE PUT A CHECK IN TO MAKE SURE WE DO
			# NOT PROCESS THE SAME SET OF PARAMETERS TWICE (WHICH WE ASSUME ARE IN ORDER)
			# WE DO THIS BY COMPARING THE SET WE HAVE JUST PROCESSED TO THE ONE IN THE NEXT ROW
			# THUS IT IS IMPORTANT THIS FILE IS IN ORDER
			STRING_SIM_PARAMS_LAST_PROCESSED<-""
			
			# NOW PROCESS EACH ROW OF THE RESULTS FILE
			for(row in 1:nrow(LHC_ALL_SIM_RESULTS))
			{
				# GET THE PARAMETERS FROM THE RESULT FILE - length parameters put in such that the output measures are not included
				SIM_PARAMS<-LHC_ALL_SIM_RESULTS[row,1:length(PARAMETERS)]
				# CONVERT TO A STRING TO DO THE COMPARISON DISCUSSED ABOVE
				STRING_SIM_PARAMS<-paste(SIM_PARAMS,collapse=" ")
				
				if(STRING_SIM_PARAMS!=STRING_SIM_PARAMS_LAST_PROCESSED)
				{
					STRING_SIM_PARAMS_LAST_PROCESSED<-STRING_SIM_PARAMS

					# CONSTRUCTING A ROW, SO ADD THE PARAMETERS TO BEGIN THIS
					SUMMARY_SIM_ROW<-SIM_PARAMS

					# NOW TO SUBSET THE RESULTS (WHICH CONTAIN MULTIPLE SIM RESULTS FOR THIS SET OF PARAMETERS) TO CALC MEDIANS
					PARAM_RESULT<-subset_results_by_param_value_set(PARAMETERS,LHC_ALL_SIM_RESULTS,SIM_PARAMS)

					# NOW WE CAN CALCULATE MEDIANS FOR EACH MEASURE
					for(l in 1:length(MEASURES))
					{
						SUMMARY_SIM_ROW<-cbind(SUMMARY_SIM_ROW,median(PARAM_RESULT[[MEASURES[l]]]))

					}

					# NOW ADD THE ROW TO THE SET FOR ALL SIMULATIONS
					SUMMARYTABLE<-rbind(SUMMARYTABLE,SUMMARY_SIM_ROW)

					ROW_POINTER<-ROW_POINTER+1
				}
			

			}


			# NOW ADD HEADERS TO THIS INFORMATION AND WRITE TO FILE
			colnames(SUMMARYTABLE)<-c(PARAMETERS,MEASURES)

			SUMMARYRESULTSFILE<-paste(FILEPATH,"/",LHCSUMMARYFILENAME,sep="")
			write.csv(SUMMARYTABLE,SUMMARYRESULTSFILE,quote = FALSE,row.names=FALSE)

			print(paste("LHC Summary file output to ",SUMMARYRESULTSFILE,sep=""))
		}
		else
		{
			print("The directory specified in FILEPATH does not exist. No analysis performed")
		}
	}
	else
	{
		# PROCESS EACH TIMEPOINT, BY AMENDING THE FILENAMES AND RECALLING THIS FUNCTION
		for(n in 1:length(TIMEPOINTS))
		{
			TIMEPOINTPROCESSING<-TIMEPOINTS[n]
			print(paste("PROCESSING TIMEPOINT: ",TIMEPOINTPROCESSING,sep=""))

			LHC_ALL_SIM_RESULTS_FORMAT<-substr(LHC_ALL_SIM_RESULTS_FILE,(nchar(LHC_ALL_SIM_RESULTS_FILE)+1)-3,nchar(LHC_ALL_SIM_RESULTS_FILE))
			LHC_ALL_SIM_RESULTS_FULL<-paste(substr(LHC_ALL_SIM_RESULTS_FILE,0,nchar(LHC_ALL_SIM_RESULTS_FILE)-4),"_",TIMEPOINTPROCESSING,".",LHC_ALL_SIM_RESULTS_FORMAT,sep="")

			LHCSUMMARYFILENAME_FORMAT<-substr(LHCSUMMARYFILENAME,(nchar(LHCSUMMARYFILENAME)+1)-3,nchar(LHCSUMMARYFILENAME))
			LHCSUMMARYFILENAME_FULL<-paste(substr(LHCSUMMARYFILENAME,0,nchar(LHCSUMMARYFILENAME)-4),"_",TIMEPOINTPROCESSING,".",LHCSUMMARYFILENAME_FORMAT,sep="")

			lhc_generateLHCSummary(FILEPATH,PARAMETERS,MEASURES,LHC_ALL_SIM_RESULTS_FULL,LHCSUMMARYFILENAME_FULL,
							SPARTAN_PARAMETER_FILE,NULL,NULL)

		}
	}
	
}

