% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3-generics.R, R/s3-sparsebnData.R
\name{coerce_discrete}
\alias{coerce_discrete}
\alias{coerce_discrete.factor}
\alias{coerce_discrete.numeric}
\alias{coerce_discrete.integer}
\alias{coerce_discrete.character}
\alias{coerce_discrete.data.frame}
\alias{coerce_discrete.sparsebnData}
\title{Recode discrete data}
\usage{
coerce_discrete(x)

\method{coerce_discrete}{factor}(x)

\method{coerce_discrete}{numeric}(x)

\method{coerce_discrete}{integer}(x)

\method{coerce_discrete}{character}(x)

\method{coerce_discrete}{data.frame}(x)

\method{coerce_discrete}{sparsebnData}(x)
}
\arguments{
\item{x}{an R object to coerce.}
}
\description{
Recodes discrete data so that the levels correspond to \code{0...n-1}, where \code{n}
is the total number of levels in a discrete factor.
}
\details{
Assumes data is unordered. Ordered factors are not supported at this time.
}
\examples{
x <- 1:5
coerce_discrete(x) # output: 0 1 2 3 4

x <- c("high", "normal", "high", "low")
coerce_discrete(x) # output: 0 2 0 1

}
