% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spark_invoke.R
\name{invoke}
\alias{invoke}
\alias{invoke_static}
\alias{invoke_new}
\title{Invoke a Method on a JVM Object}
\usage{
invoke(jobj, method, ...)

invoke_static(sc, class, method, ...)

invoke_new(sc, class, ...)
}
\arguments{
\item{jobj}{An \R object acting as a Java object reference (typically, a \code{spark_jobj}).}

\item{method}{The name of the method to be invoked.}

\item{...}{Optional arguments, currently unused.}

\item{sc}{A \code{spark_connection}.}

\item{class}{The name of the Java class whose methods should be invoked.}
}
\description{
Invoke methods on Java object references. These functions provide a
mechanism for invoking various Java object methods directly from \R.
}
\details{
Use each of these functions in the following scenarios:

\tabular{lll}{
\code{invoke} \tab Execute a method on a Java object reference (typically, a \code{spark_jobj}). \cr
\code{invoke_static} \tab Execute a static method associated with a Java class. \cr
\code{invoke_new} \tab Invoke a constructor associated with a Java class. \cr
}
}
