% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ml_classification_linear_svc.R
\name{ml_linear_svc}
\alias{ml_linear_svc}
\title{Spark ML -- LinearSVC}
\usage{
ml_linear_svc(
  x,
  formula = NULL,
  fit_intercept = TRUE,
  reg_param = 0,
  max_iter = 100,
  standardization = TRUE,
  weight_col = NULL,
  tol = 1e-06,
  threshold = 0,
  aggregation_depth = 2,
  features_col = "features",
  label_col = "label",
  prediction_col = "prediction",
  raw_prediction_col = "rawPrediction",
  uid = random_string("linear_svc_"),
  ...
)
}
\arguments{
\item{x}{A \code{spark_connection}, \code{ml_pipeline}, or a \code{tbl_spark}.}

\item{formula}{Used when \code{x} is a \code{tbl_spark}. R formula as a character string or a formula. This is used to transform the input dataframe before fitting, see \link{ft_r_formula} for details.}

\item{fit_intercept}{Boolean; should the model be fit with an intercept term?}

\item{reg_param}{Regularization parameter (aka lambda)}

\item{max_iter}{The maximum number of iterations to use.}

\item{standardization}{Whether to standardize the training features before fitting the model.}

\item{weight_col}{The name of the column to use as weights for the model fit.}

\item{tol}{Param for the convergence tolerance for iterative algorithms.}

\item{threshold}{in binary classification prediction, in range [0, 1].}

\item{aggregation_depth}{(Spark 2.1.0+) Suggested depth for treeAggregate (>= 2).}

\item{features_col}{Features column name, as a length-one character vector. The column should be single vector column of numeric values. Usually this column is output by \code{\link{ft_r_formula}}.}

\item{label_col}{Label column name. The column should be a numeric column. Usually this column is output by \code{\link{ft_r_formula}}.}

\item{prediction_col}{Prediction column name.}

\item{raw_prediction_col}{Raw prediction (a.k.a. confidence) column name.}

\item{uid}{A character string used to uniquely identify the ML estimator.}

\item{...}{Optional arguments; see Details.}
}
\value{
The object returned depends on the class of \code{x}. If it is a
\code{spark_connection}, the function returns a \code{ml_estimator} object. If
it is a \code{ml_pipeline}, it will return a pipeline with the predictor
appended to it. If a \code{tbl_spark}, it will return a \code{tbl_spark} with
the predictions added to it.
}
\description{
Perform classification using linear support vector machines (SVM). This binary classifier optimizes the Hinge Loss using the OWLQN optimizer. Only supports L2 regularization currently.
}
\examples{
\dontrun{
library(dplyr)

sc <- spark_connect(master = "local")
iris_tbl <- sdf_copy_to(sc, iris, name = "iris_tbl", overwrite = TRUE)

partitions <- iris_tbl \%>\%
  filter(Species != "setosa") \%>\%
  sdf_random_split(training = 0.7, test = 0.3, seed = 1111)

iris_training <- partitions$training
iris_test <- partitions$test

svc_model <- iris_training \%>\%
  ml_linear_svc(Species ~ .)

pred <- ml_predict(svc_model, iris_test)

ml_binary_classification_evaluator(pred)
}

}
\seealso{
Other ml algorithms: 
\code{\link{ml_aft_survival_regression}()},
\code{\link{ml_decision_tree_classifier}()},
\code{\link{ml_gbt_classifier}()},
\code{\link{ml_generalized_linear_regression}()},
\code{\link{ml_isotonic_regression}()},
\code{\link{ml_linear_regression}()},
\code{\link{ml_logistic_regression}()},
\code{\link{ml_multilayer_perceptron_classifier}()},
\code{\link{ml_naive_bayes}()},
\code{\link{ml_one_vs_rest}()},
\code{\link{ml_random_forest_classifier}()}
}
\concept{ml algorithms}
