% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ml_fpm_prefixspan.R
\name{ml_prefixspan}
\alias{ml_prefixspan}
\alias{ml_freq_seq_patterns}
\title{Frequent Pattern Mining -- PrefixSpan}
\usage{
ml_prefixspan(
  x,
  seq_col = "sequence",
  min_support = 0.1,
  max_pattern_length = 10,
  max_local_proj_db_size = 3.2e+07,
  uid = random_string("prefixspan_"),
  ...
)

ml_freq_seq_patterns(model)
}
\arguments{
\item{x}{A \code{spark_connection}, \code{ml_pipeline}, or a \code{tbl_spark}.}

\item{seq_col}{The name of the sequence column in dataset (default
“sequence”). Rows with nulls in this column are ignored.}

\item{min_support}{The minimum support required to be considered a frequent
sequential pattern.}

\item{max_pattern_length}{The maximum length of a frequent sequential
pattern. Any frequent pattern exceeding this length will not be included in
the results.}

\item{max_local_proj_db_size}{The maximum number of items allowed in a
prefix-projected database before local iterative processing of the
projected database begins. This parameter should be tuned with respect to
the size of your executors.}

\item{uid}{A character string used to uniquely identify the ML estimator.}

\item{...}{Optional arguments; currently unused.}

\item{model}{A Prefix Span model.}
}
\description{
PrefixSpan algorithm for mining frequent itemsets.
}
