% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dplyr_hof.R
\name{\%->\%}
\alias{\%->\%}
\title{Infix operator for composing a lambda expression}
\usage{
params \%->\% body
}
\arguments{
\item{params}{Parameter(s) of the lambda expression, can be either a single
parameter or a comma separated listed of parameters in the form of
\code{.(param1, param2, ... )} (see examples)}

\item{body}{Body of the lambda expression, *must be within parentheses*}
}
\description{
Infix operator that allows a lambda expression to be composed in R and be
translated to Spark SQL equivalent using ' \code{dbplyr::translate_sql} functionalities
}
\details{
Notice when composing a lambda expression in R, the body of the lambda expression
*must always be surrounded with parentheses*, otherwise a parsing error will occur.
}
\examples{
\dontrun{

a \%->\% (mean(a) + 1) # translates to <SQL> `a` -> (AVG(`a`) OVER () + 1.0)

.(a, b) \%->\% (a < 1 && b > 1) # translates to <SQL> `a`,`b` -> (`a` < 1.0 AND `b` > 1.0)
}
}
