/*
 * Decompiled with CFR 0.152.
 */
package com.univocity.parsers.common.input;

import com.univocity.parsers.common.input.CharInputReader;
import com.univocity.parsers.common.input.EOFException;
import java.io.Reader;

public abstract class AbstractCharInputReader
implements CharInputReader {
    private boolean lineSeparatorDefined;
    private final boolean detectLineSeparator;
    private char lineSeparator1;
    private char lineSeparator2;
    private final char normalizedLineSeparator;
    private long lineCount;
    private long charCount;
    public int i;
    public char[] buffer;
    public int length = -1;

    public AbstractCharInputReader(char normalizedLineSeparator) {
        this.detectLineSeparator = true;
        this.lineSeparator1 = '\u0000';
        this.lineSeparator2 = '\u0000';
        this.normalizedLineSeparator = normalizedLineSeparator;
    }

    public AbstractCharInputReader(char[] lineSeparator, char normalizedLineSeparator) {
        this.detectLineSeparator = false;
        if (lineSeparator == null || lineSeparator.length == 0) {
            throw new IllegalArgumentException("Invalid line separator. Expected 1 to 2 characters");
        }
        if (lineSeparator.length > 2) {
            throw new IllegalArgumentException("Invalid line separator. Up to 2 characters are expected. Got " + lineSeparator.length + " characters.");
        }
        this.lineSeparator1 = lineSeparator[0];
        this.lineSeparator2 = lineSeparator.length == 2 ? lineSeparator[1] : (char)'\u0000';
        this.normalizedLineSeparator = normalizedLineSeparator;
    }

    protected abstract void setReader(Reader var1);

    protected abstract void reloadBuffer();

    @Override
    public final void start(Reader reader) {
        this.stop();
        this.setReader(reader);
        this.lineSeparatorDefined = false;
        this.lineCount = 0L;
        this.updateBuffer();
        if (this.length > 0) {
            ++this.i;
        }
    }

    private final void updateBuffer() {
        this.reloadBuffer();
        this.charCount += (long)this.i;
        this.i = 0;
        if (this.length == -1) {
            this.stop();
        }
        if (this.detectLineSeparator && !this.lineSeparatorDefined) {
            this.detectLineSeparator();
        }
    }

    private final void detectLineSeparator() {
        int separator1 = 0;
        int separator2 = 0;
        for (int c = 0; c < this.length; ++c) {
            int ch = this.buffer[c];
            if (ch == 10 || ch == 13) {
                if (separator1 == 0) {
                    separator1 = ch;
                    continue;
                }
                separator2 = ch;
                break;
            }
            if (separator1 != 0) break;
        }
        if (separator1 != 0) {
            if (separator1 == 10) {
                this.lineSeparator1 = (char)10;
                this.lineSeparator2 = '\u0000';
            } else if (separator1 == 13) {
                this.lineSeparator1 = (char)13;
                this.lineSeparator2 = separator2 == 10 ? (char)10 : (char)'\u0000';
            }
            this.lineSeparatorDefined = true;
        }
    }

    @Override
    public final char nextChar() {
        if (this.length == -1) {
            throw new EOFException();
        }
        char ch = this.buffer[this.i - 1];
        if (this.i >= this.length) {
            if (this.length != -1) {
                this.updateBuffer();
            } else {
                throw new EOFException();
            }
        }
        ++this.i;
        if (this.lineSeparator1 == ch && (this.lineSeparator2 == '\u0000' || this.lineSeparator2 == this.buffer[this.i - 1])) {
            ++this.lineCount;
            if (this.lineSeparator2 != '\u0000') {
                ch = this.normalizedLineSeparator;
                if (this.i >= this.length) {
                    if (this.length != -1) {
                        this.updateBuffer();
                    } else {
                        throw new EOFException();
                    }
                }
                if (this.i < this.length) {
                    ++this.i;
                }
            } else {
                return this.normalizedLineSeparator;
            }
        }
        return ch;
    }

    @Override
    public final long lineCount() {
        return this.lineCount;
    }

    @Override
    public final void skipLines(int lines) {
        if (lines < 1) {
            return;
        }
        long expectedLineCount = this.lineCount + (long)lines;
        try {
            do {
                this.nextChar();
            } while (this.lineCount < expectedLineCount);
            if (this.lineCount < (long)lines) {
                throw new IllegalArgumentException("Unable to skip " + lines + " lines from line " + (expectedLineCount - (long)lines) + ". End of input reached");
            }
        }
        catch (EOFException ex) {
            throw new IllegalArgumentException("Unable to skip " + lines + " lines from line " + (expectedLineCount - (long)lines) + ". End of input reached");
        }
    }

    @Override
    public final long charCount() {
        return this.charCount + (long)this.i;
    }
}

