/*
 * Decompiled with CFR 0.152.
 */
package com.univocity.parsers.common.processor;

import com.univocity.parsers.common.ArgumentUtils;
import com.univocity.parsers.common.ParsingContext;
import com.univocity.parsers.common.processor.MasterDetailRecord;
import com.univocity.parsers.common.processor.ObjectRowListProcessor;
import com.univocity.parsers.common.processor.ObjectRowProcessor;
import com.univocity.parsers.common.processor.RowPlacement;
import java.util.ArrayList;
import java.util.List;

public abstract class MasterDetailProcessor
extends ObjectRowProcessor {
    private ObjectRowListProcessor detailProcessor;
    private MasterDetailRecord record;
    private boolean isMasterRowAboveDetail;

    public MasterDetailProcessor(RowPlacement rowPlacement, ObjectRowListProcessor detailProcessor) {
        ArgumentUtils.noNulls("Row processor for reading detail rows", detailProcessor);
        this.detailProcessor = detailProcessor;
        this.isMasterRowAboveDetail = rowPlacement == RowPlacement.TOP;
    }

    public MasterDetailProcessor(ObjectRowListProcessor detailProcessor) {
        this(RowPlacement.TOP, detailProcessor);
    }

    @Override
    public void processStarted(ParsingContext context) {
        this.detailProcessor.processStarted(context);
    }

    @Override
    public final void rowProcessed(String[] row, ParsingContext context) {
        if (this.isMasterRecord(row, context)) {
            super.rowProcessed(row, context);
        } else {
            this.detailProcessor.rowProcessed(row, context);
        }
    }

    @Override
    public final void rowProcessed(Object[] row, ParsingContext context) {
        if (this.record == null) {
            this.record = new MasterDetailRecord();
            this.record.setMasterRow(row);
            if (this.isMasterRowAboveDetail) {
                return;
            }
        }
        this.processRecord(row, context);
    }

    private void processRecord(Object[] row, ParsingContext context) {
        List<Object[]> detailRows = this.detailProcessor.getRows();
        this.record.setDetailRows(new ArrayList<Object[]>(detailRows));
        if (!this.isMasterRowAboveDetail) {
            this.record.setMasterRow(row);
        }
        if (this.record.getMasterRow() != null) {
            this.masterDetailRecordProcessed(this.record.clone(), context);
            this.record.clear();
        }
        detailRows.clear();
        if (this.isMasterRowAboveDetail) {
            this.record.setMasterRow(row);
        }
    }

    @Override
    public void processEnded(ParsingContext context) {
        super.processEnded(context);
        this.detailProcessor.processEnded(context);
        if (this.isMasterRowAboveDetail) {
            this.processRecord(null, context);
        }
    }

    protected abstract boolean isMasterRecord(String[] var1, ParsingContext var2);

    protected abstract void masterDetailRecordProcessed(MasterDetailRecord var1, ParsingContext var2);
}

