% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sdf_saveload.R
\name{sdf-saveload}
\alias{sdf-saveload}
\alias{sdf_save_table}
\alias{sdf_load_table}
\alias{sdf_save_parquet}
\alias{sdf_load_parquet}
\title{Save / Load a Spark DataFrame}
\usage{
sdf_save_table(x, name, overwrite = FALSE, append = FALSE)

sdf_load_table(sc, name)

sdf_save_parquet(x, path, overwrite = FALSE, append = FALSE)

sdf_load_parquet(sc, path)
}
\arguments{
\item{x}{An object coercable to a Spark DataFrame (typically, a
\code{tbl_spark}).}

\item{name}{The table name to assign to the saved Spark DataFrame.}

\item{overwrite}{Boolean; overwrite a pre-existing table of the same name?}

\item{append}{Boolean; append to a pre-existing table of the same name?}

\item{sc}{A \code{spark_connection} object.}

\item{path}{The path where the Spark DataFrame should be saved.}
}
\description{
Routines for saving and loading Spark DataFrames.
}
