/*
 * Decompiled with CFR 0.152.
 */
package sparklyr;

import java.io.File;
import java.io.FileWriter;
import java.util.Arrays;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkEnv$;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.StringAdd$;
import sparklyr.FileUtils$;
import sparklyr.Logger;
import sparklyr.Sources$;

@ScalaSignature(bytes="\u0006\u000192A!\u0001\u0002\u0001\u000b\t9!k]2sSB$(\"A\u0002\u0002\u0011M\u0004\u0018M]6msJ\u001c\u0001a\u0005\u0002\u0001\rA\u0011qAC\u0007\u0002\u0011)\t\u0011\"A\u0003tG\u0006d\u0017-\u0003\u0002\f\u0011\t1\u0011I\\=SK\u001aD\u0001\"\u0004\u0001\u0003\u0002\u0003\u0006IAD\u0001\u0007Y><w-\u001a:\u0011\u0005=\u0001R\"\u0001\u0002\n\u0005E\u0011!A\u0002'pO\u001e,'\u000fC\u0003\u0014\u0001\u0011\u0005A#\u0001\u0004=S:LGO\u0010\u000b\u0003+Y\u0001\"a\u0004\u0001\t\u000b5\u0011\u0002\u0019\u0001\b\t\u000ba\u0001A\u0011A\r\u0002!]|'o[3s'>,(oY3GS2,G#\u0001\u000e\u0011\u0005mqbBA\u0004\u001d\u0013\ti\u0002\"\u0001\u0004Qe\u0016$WMZ\u0005\u0003?\u0001\u0012aa\u0015;sS:<'BA\u000f\t\u0011\u0015\u0011\u0003\u0001\"\u0001$\u0003\u0011Ig.\u001b;\u0015\u0007\u0011:C\u0006\u0005\u0002\bK%\u0011a\u0005\u0003\u0002\u0005+:LG\u000fC\u0003)C\u0001\u0007\u0011&A\u0005tKN\u001c\u0018n\u001c8JIB\u0011qAK\u0005\u0003W!\u00111!\u00138u\u0011\u0015i\u0013\u00051\u0001\u001b\u0003\u0019\u0019wN\u001c4jO\u0002")
public class Rscript {
    private final Logger logger;

    public String workerSourceFile() {
        String source = Sources$.MODULE$.sources();
        File tempFile = new File(new StringBuilder().append((Object)StringAdd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)FileUtils$.MODULE$.createTempDir()), File.separator)).append((Object)"sparkworker.R").toString());
        FileWriter outStream = new FileWriter(tempFile);
        outStream.write(source);
        outStream.flush();
        return tempFile.getAbsolutePath();
    }

    public void init(int sessionId, String config) {
        SparkConf sparkConf = SparkEnv$.MODULE$.get().conf();
        String command = sparkConf.get("spark.r.command", "Rscript");
        String sourceFilePath = this.workerSourceFile();
        this.logger.log(new StringBuilder().append((Object)"using source file ").append((Object)sourceFilePath).toString());
        this.logger.log(new StringBuilder().append((Object)"launching command ").append((Object)command).append((Object)" --vanilla <source-file> ").append((Object)((Object)BoxesRunTime.boxToInteger((int)sessionId)).toString()).append((Object)" ").append((Object)config).toString());
        ProcessBuilder processBuilder = new ProcessBuilder(Arrays.asList((Object[])new String[]{command, "--vanilla", sourceFilePath, ((Object)BoxesRunTime.boxToInteger((int)sessionId)).toString(), config}));
        processBuilder.redirectErrorStream(true);
        processBuilder.redirectOutput(ProcessBuilder.Redirect.INHERIT);
        this.logger.log("is starting R process");
        Process process = processBuilder.start();
        int status = process.waitFor();
        if (status == 0) {
            this.logger.log("completed R process");
            return;
        }
        this.logger.logError("failed to complete R process");
        throw new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"sparklyr worker rscript failure, check worker logs for details."})).s((Seq)Nil$.MODULE$));
    }

    public Rscript(Logger logger) {
        this.logger = logger;
    }
}

