% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dicom_reader.R
\name{dicom_reader}
\alias{dicom_reader}
\title{A very simple DICOM reader.}
\usage{
dicom_reader(
  input,
  tags = list(sop_class_uid = "0008,0016"),
  endian = "little",
  debug = FALSE
)
}
\arguments{
\item{input}{either a file path or raw binary object.}

\item{tags}{a named list of tags to be extracted from the file.
eg tags <- list(spec_data = "7FE1,1010", pat_name = "0010,0010")}

\item{endian}{can be "little" or "big".}

\item{debug}{print out some debugging information, can be "little" or "big".}
}
\value{
a list with the same structure as the input, but with tag codes
replaced with the corresponding data in a raw format.
}
\description{
Note this reader is very basic and does not use a DICOM dictionary or try to
convert the data to the correct datatype. For a more robust and sophisticated
reader use the oro.dicom package.
}
