% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_values.R
\name{generate_sobol_set}
\alias{generate_sobol_set}
\title{Generate Sobol Set}
\usage{
generate_sobol_set(n, dim, seed = 0)
}
\arguments{
\item{n}{The number of values (per dimension) to extract.}

\item{dim}{The number of dimensions of the sequence.}

\item{seed}{Default `0`. The random seed.}
}
\value{
A single numeric value representing the `i`th element in the `dim` dimension.
}
\description{
Generate a set of values from a Sobol set.

Note: the Sobol sequences provided by spacefillr are different than those provided by randtoolbox,
as spacefillr's Sobol sequences have better 2D projections
(see "Constructing Sobol sequences with better two-dimensional projections" (2012) <doi:10.1137/070709359> S. Joe and F. Y. Kuo).
}
\examples{
#Generate a 2D sample:
points2d = generate_sobol_set(n=1000, dim = 2)
plot(points2d, xlim=c(0,1),ylim=c(0,1))

#Generate a longer sequence of values from that set
points2d = generate_sobol_set(n=1500, dim = 2)
plot(points2d, xlim=c(0,1),ylim=c(0,1))

#'#Integrate the value of pi by counting the number of randomly generated points that fall
#within the unit circle.
pointset = matrix(generate_sobol_set(10000,dim=2),ncol=2)

pi_estimate = 4*sum(pointset[,1] * pointset[,1] + pointset[,2] * pointset[,2] < 1)/10000
pi_estimate
}
