% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geometrical_functions_sf.R
\name{split_lines_at_vertex}
\alias{split_lines_at_vertex}
\title{Split lines at vertices in a feature collection of linestrings}
\usage{
split_lines_at_vertex(lines, points, nearest_lines_idx, mindist)
}
\arguments{
\item{lines}{The feature collection of linestrings to split}

\item{points}{The feature collection of points to add to as vertex to the lines}

\item{nearest_lines_idx}{For each point, the index of the nearest line}

\item{mindist}{The minimum distance between one point and the extremity of
the line to add the point as a vertex.}
}
\value{
A feature collection of linestrings
}
\description{
Split lines (feature collection of linestrings) at their nearest vertices
(feature collection of points), may fail if the line geometries are self intersecting.
}
\examples{
\donttest{
# reading the data
data(mtl_network)
data(bike_accidents)
# aggregating points within a 5 metres radius
bike_accidents$weight <- 1
agg_points <- aggregate_points(bike_accidents, 5)
mtl_network$LineID <- 1:nrow(mtl_network)
# snapping point to lines
snapped_points <- snapPointsToLines2(agg_points,
    mtl_network,
    "LineID"
)
# splitting lines
new_lines <- split_lines_at_vertex(mtl_network, snapped_points,
    snapped_points$nearest_line_id, 1)
}
}
